'use strict';

const Controller = require('egg').Controller;

class UserController extends Controller {

    /**
     * 
     */
    async getBabyInfo() {

        const { ctx } = this;
        const result = await ctx.service.course.user.getBabyInfo();

        ctx.success({ result });
    }

    async saveBabyInfo() {

        const { ctx } = this;
        const input_params = ctx.request.body;
        const result = await ctx.service.course.user.saveBabyInfo(input_params);

        ctx.success({ result });
    }

    async delBabyInfo() {

        const { ctx } = this;
        const result = await ctx.service.course.user.delBabyInfo();

        ctx.success({ result });
    }


    async getCollectInstitutions() {

        const { ctx } = this;
        const input_params = ctx.request.body;
        const result = await ctx.service.course.user.getCollectInstitutions(input_params);

        ctx.success({ result });
    }


    async collectInstitution() {

        const { ctx } = this;
        const institution_id = ctx.request.body.institution_id;
        if (!institution_id) {
            ctx.failed('error institution_id');
        }
        const result = await ctx.service.course.user.collectInstitution(institution_id);

        ctx.success({ result });
    }




}

module.exports = UserController;
