
'use strict';

const Service = require('egg').Service;
const moment = require('moment');

class searchHistoryService extends Service {

    /**
     * 添加搜索历史
     * @param {object} inputParams 
     */
    async addSearchHistory(inputParams) {
        const { ctx } = this;
        if (!ctx.userId) {
            return false;
        }
        let data = {
            user_id: ctx.userId,
            app_user_id: ctx.appUserId,
            key_word: inputParams.key_word,
            house_style: inputParams.type,
            state: 1,
        };
        let retId = await ctx.realestateModel.SearchHistory.add(data);
        return { id: retId };
    }

    /**
     * 获取搜索历史
     * 历史记录取用户最近6个月的搜索记录，去重处理，条数不超过50条
     * 排序根据搜索时间逆序排列，距离当前时间近的排在前面，重复搜索的关键词取最近一次的搜索时间进行排序
     * 如果没有搜索记录的就不显示搜索词
     */
    async getSearchHistoryList(type) {
        const { ctx } = this;
        let ret = {
            results: [],
            count: 0
        };
        if (!ctx.appUserId || !ctx.deviceId || !ctx.deviceLoginId || !ctx.userId) {
            //如果没有登录就返回空
            return ret;
        }
        let endDate = moment().subtract(180, 'days').format('YYYY-MM-DD HH:mm:ss');
        let filter = {
            page: 1,
            limit: 50,
            where: {
                state: 1,
                user_id: ctx.userId,
                created_at: { $gt: endDate }
            }
        }
        if (type) {
            filter.where.house_style = type;
        }
        let list = [];
        let searchHistoryList = await ctx.realestateModel.SearchHistory.all(filter);
        if (searchHistoryList.length > 0) {
            for (let i in searchHistoryList) {
                if (list.indexOf(searchHistoryList[i].keyWord) === -1) {
                    list.push(searchHistoryList[i].keyWord);
                }
            }
        }
        ctx.logger.info(list);

        ret = {
            results: list,
            count: list.length
        };
        return ret;
    }


    /**
     * 用户点击清除搜索记录
     */
    async cleanSearchHistory(type) {
        const { ctx } = this;
        let ret = { status: true };
        if (!ctx.appUserId || !ctx.deviceId || !ctx.deviceLoginId || !ctx.userId) {
            //如果没有登录就不做处理
            return ret;
        }
        let filter = {
            where: {
                state: 1,
                user_id: ctx.userId,
                house_style: type
            }
        }
        let searchHistoryList = await ctx.realestateModel.SearchHistory.all(filter);

        if (searchHistoryList.length > 0) {
            let updateFilter = {
                params: { state: 0 },
                where: {
                    house_style: type,
                    user_id: ctx.userId
                }
            }
            await ctx.realestateModel.SearchHistory.edit(updateFilter);
        }
        return ret;


    }

}

module.exports = searchHistoryService;
