
'use strict';

const Service = require('egg').Service;
const moment = require('moment');

class CheckService extends Service {

    /**
     * 获取用户的手机号(打码)
     */
    async getUserHidePhone() {
        const { ctx } = this;
        let ret = {
            isLogin: false,
            hidePhone: ''
        };
        if (!ctx.oldUserId || !ctx.userId) {
            //如果没有登录就不做处理
            return ret;
        }
        let userSid = isNaN(ctx.oldUserId) ? ctx.helper.decodeUserSid(ctx.oldUserId) : ctx.oldUserId;
        let filter = {
            attributes: ['passport'],
            where: {
                sid: userSid,
                yys_cid: 10
            }
        }
        let userInfo = await ctx.gjjModel.SysUser.findOne(filter);
        if (!userInfo) {
            ctx.failed('没有找到对应的手机号');
        }
        ret.hidePhone = userInfo.passport.replace(/(\d{3})\d{4}(\d{4})/, '$1****$2');
        return ret;
    }

    /**
     * 签名,加密
     * @param {object} params 需要加密的参数对象
     */
    async sign(params) {
        const { ctx } = this;
        let signKey = this.config.DXM_SECRET;
        let sign = '';
        if (!params) {
            ctx.failed('params is empty');
        }
        //键名排序
        const sortParamsKey = Object.keys(params).sort();
        //键值拼接-升序
        let sortValues = '';
        for (let i in sortParamsKey) {
            if (['sign', 'Sign'].includes(sortParamsKey[i])) {
                continue;
            }
            sortValues += sortParamsKey[i] + '=' + params[sortParamsKey[i]] + '&';
        }
        sortValues = sortValues.substring(0, sortValues.length - 1) + signKey;
        sign = ctx.helper.md5(sortValues);
        ctx.logger.info({ sign: sign });
        return sign;
    }

    async check() {
        const { ctx } = this;
        if (!ctx.oldUserId || !ctx.userId) {
            //如果没有登录就不做处理
            ctx.failed('登录异常');
        }
        let userSid = isNaN(ctx.oldUserId) ? ctx.helper.decodeUserSid(ctx.oldUserId) : ctx.oldUserId;
        let filter = {
            attributes: ['passport'],
            where: {
                sid: userSid,
                yys_cid: 10
            }
        }
        let userInfo = await ctx.gjjModel.SysUser.findOne(filter);
        if (!userInfo) {
            ctx.failed('没有找到对应的手机号');
        }
        let params = {
            app_id: this.config.DXM_APP_ID,
            datetime: new Date.getTime(),
            phone: ctx.helper.md5(userInfo.passport),
            fr: 'gjj_test',//TODO,线下测试随意,不为空即可
            sign: '',
        }
        params.sign = await this.sign(params);
        let dxmUrl = this.config.DXM_URL + '?';
        for (let i in params) {
            dxmUrl += i + '=' + params[i] + '&';
        }
        dxmUrl = dxmUrl.substring(0, dxmUrl.length - 1);
        ctx.logger.info('dxmUrl:' + dxmUrl);
        let result = await ctx.helper.send_request(dxmUrl, {}, { method: 'GET' });
        ctx.logger.info('result:' + JSON.stringify(result));
        return result;



    }






}

module.exports = CheckService;
