'use strict';

const moment = require('moment');

module.exports = app => {
    const { INTEGER, STRING, DATE, DECIMAL } = app.Sequelize;
    const CreditOrderPreferential = app.prometheusModel.define('credit_order_preferential', {
        id: {
            type: INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        type: INTEGER,
        alias: STRING,
        title: STRING,
        price: DECIMAL,
        description: STRING,
        valid: INTEGER
    }, {
        timestamps: false,
        tableName: 'credit_order_preferential',
    });

    return CreditOrderPreferential;

};
