'use strict';

const Controller = require('egg').Controller;

class PresellHouseController extends Controller {

    /**
     * 预售楼盘列表
     */
    async getPresellHouseList() {
        const { ctx } = this;
        let inputParams = ctx.request.body;
        let rule = {
            page: { type: 'number', required: true },
            limit: { type: 'number', required: true },
            name: { type: 'string', required: false },
        };
        ctx.validate(rule, inputParams);
        let ret = await ctx.service.cd.presellHouse.getList(inputParams);
        ctx.success(ret);
    }

}

module.exports = PresellHouseController;
