'use strict';
const Service = require('egg').Service;
const APPID = 'wx4769ebba9b91f8ec';
const SECRET = '680440637b4e38c9b66529cfd5dc590e';
const fs = require('fs');
const request = require('request');

class WechatService extends Service {
  async getAccessToken() {
    const { ctx } = this;
    const url = 'https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=' + APPID + '&secret=' + SECRET;

    // 先从redis中取
    let token = await this.app.memcache.get('wechat_course_accessToken');
    if (ctx.isEmpty(token)) {
      const resp = await ctx.helper.send_request(url, {}, { method: 'GET' });
      if (resp.status === 200 && !ctx.isEmpty(resp.data) && !ctx.isEmpty(resp.data.access_token)) {
        token = resp.data.access_token;
        await this.app.memcache.set('wechat_course_accessToken', token, resp.data.expires_in);
      }
    }

    return token;
  }

  async callbackAction() {
    const { ctx, app } = this;
    ctx.logger.info('course_wechat_receive: ' + JSON.stringify(ctx.request.body));
    await this.sendMsg(ctx.request.body);
  }

  async sendMsg(data) {
    const { ctx, app } = this;

    if (ctx.isEmpty(data)) {
      return;
    }

    //只有MsgType为miniprogrampage才发送
    if (ctx.isEmpty(data.MsgType) || data.MsgType !== 'miniprogrampage') {
        return;
    }

    let mediaId = await this.app.memcache.get('course_wechat_service_image_media_id');

    if (ctx.isEmpty(mediaId)) {
      const images = 'data:image/jpeg;base64,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';
        const image = images.replace(/^data:image\/\w+;base64,/, '');
        const imgBuffer = Buffer.from(image, 'base64');
        fs.writeFile("image.jpg", imgBuffer, function(err){});
        const file = fs.createReadStream('image.jpg');
        const imageInfo = {media: file};
      mediaId = await this.uploadTempMedia(imageInfo);
      await this.app.memcache.set('course_wechat_service_image_media_id', mediaId, 72*3600);
    }

    if (ctx.isEmpty(mediaId)) {
      return;
    }

    const token = await this.getAccessToken();
    const url = 'https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=' + token;
    const params = {
      access_token: token,
      touser: data.FromUserName,
      msgtype: 'image',
      image: { media_id: mediaId },
    };
    const resp = await ctx.helper.send_request(url, params, { method: 'POST' });
    ctx.logger.info('course_wechat_resp: ' + JSON.stringify(resp));
    return;
  }

  async getTempMedia(mediaId) {
    const { ctx } = this;
    const url = 'https://api.weixin.qq.com/cgi-bin/media/get';

    const image = await this.app.memcache.get('course_wechat_service_image');
    if (image) {
      return image;
    }

    const token = await this.getAccessToken();
    const params = {
      access_token: token,
      media_id: mediaId,
    };
    const resp = await ctx.helper.send_request(url, params, { method: 'GET' });

    let ret = '';
    if (resp.status === 200 && !ctx.isEmpty(resp.data) && resp.data.errCode === 0) {
      await this.app.memcache.set('course_wechat_service_image', resp.data.buffer, 72 * 3600);
      ret = resp.data.buffer;
    }

    return ret;
  }

  /*
  把媒体文件上传到微信服务器。目前仅支持图片。用于发送客服消息或被动回复用户消息。
  type: 'image',
  media: {
    contentType: 'image/png',
    value: Buffer
  }
  */
  async uploadTempMedia(data) {
    const { ctx, app } = this;
    if (ctx.isEmpty(data)) {
      return;
    }
    const token = await this.getAccessToken();
    const url = 'https://api.weixin.qq.com/cgi-bin/media/upload?access_token=' + token + '&type=image';
    // const resp = await ctx.helper.send_request(url, data, {method: 'POST'});
    // ctx.logger.info('course_wechat_uploadTempMedia_resp: ' + JSON.stringify(resp));

    let ret = '';
    // if (resp.status === 200 && !ctx.isEmpty(resp.data) && resp.data.errCode === 0) {
    //     await this.app.memcache.set('course_wechat_service_image_media_id', resp.data.mediaId, 72*3600);
    //     ret = resp.data.mediaId;
    // }

    request.post({ url, formData: data }, function(error, response, body) {
      const resp = {
        statusCode: response.statusCode,
        body: response.body,

      };
      ctx.logger.info('course_wechat_uploadTempMedia_resp: ' + JSON.stringify(resp));
      if (response.statusCode === 200) {
        const result = JSON.parse(body);
        ret = result.media_id;
      }
    });

    return ret;
  }
}

module.exports = WechatService;
