'use strict';

const Controller = require('egg').Controller;

class OnlineController extends Controller {

  // 获取在线课程列表
  async getClasses() {
    const { ctx, service } = this;
    const inputParams = ctx.request.query;

    const ret = await service.course.v4.online.getClasses(inputParams);
    ctx.success(ret);
  }

  // 获取在线课程详情
  async getClass() {
    const { ctx, service } = this;
    const params = ctx.params;
    const inputParams = ctx.request.query;

    if (ctx.isEmpty(params) || ctx.isEmpty(params.id)) {
      ctx.failed('id error');
    }

    const input = {
      id: params.id,
      lng: inputParams.lng || 0,
      lat: inputParams.lat || 0,
    };

    const ret = await service.course.v4.online.getClass(input);
    ctx.success(ret);
  }

  // 获取在线课程选项
  async getOption() {
    const { ctx, service } = this;

    const ret = await service.course.v4.online.getOption();
    ctx.success(ret);
  }


  // 收藏在线课程
  async collectClass() {
    const { ctx, service } = this;
    const inputParams = ctx.request.body;
    if (ctx.isEmpty(inputParams) || ctx.isEmpty(inputParams.id)) {
      ctx.failed('id is empty');
    }

    const ret = await service.course.v4.online.collectClass(inputParams.id);
    ctx.success(ret);
  }


  // 获取在线课程收藏列表
  async getCollectionClasses() {
    const { ctx, service } = this;
    const inputParams = ctx.request.query;

    const ret = await service.course.v4.online.getCollectionClasses(inputParams);
    ctx.success(ret);
  }


  // 收藏在线课程
  async delCollectClass() {
    const { ctx, service } = this;
    const inputParams = ctx.request.body;
    if (ctx.isEmpty(inputParams) || ctx.isEmpty(inputParams.id)) {
      ctx.failed('id is empty');
    }

    const ret = await service.course.v4.online.delCollectClass(inputParams.id);
    ctx.success(ret);
  }
}

module.exports = OnlineController;
