'use strict';


const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE, DECIMAL, TEXT, ENUM } = app.Sequelize;

  const CourseOnlineCat = app.classModel.define('course_online_cat', {
    id: {
      type: INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    parent_id: INTEGER,
    name: STRING,
    image: STRING,
    active_image: STRING,
    color: STRING,
    tips: STRING,
    status: ENUM('offline', 'online'),
    is_deleted: INTEGER,
    sort: INTEGER,
    created_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('created_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    updated_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('updated_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'course_online_cat',
  });

  CourseOnlineCat.one = async data => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await CourseOnlineCat.findOne({
      attributes,
      where,
    });
  };

  CourseOnlineCat.all = async data => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const order = data.order ? data.order : [];
    return await CourseOnlineCat.findAll({
      attributes,
      where,
      order,
    });
  };

  CourseOnlineCat.list = async (data = {}) => {
    const limit = data.limit ? Number(data.limit) : 10;
    const page = data.page ? data.page : 1;
    const order = data.order ? data.order : [];
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const condition = {
      offset: (page - 1) * limit,
      limit,
      where,
      order,
      attributes,
    };
    const { count, rows } = await CourseOnlineCat.findAndCountAll(condition);
    return { page, count, rows };
  };

  CourseOnlineCat.add = async data => {
    try {
      // 返回promise对象实力 instance
      const res = await CourseOnlineCat.create(data);
      // 从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
      return res.id;
    } catch (error) {
      throw (error);
    }
  };

  CourseOnlineCat.edit = async data => {
    const where = data.where;
    const params = data.params;
    try {
      const res = await CourseOnlineCat.update(params, { where });
      return res;
    } catch (error) {
      throw (error);
    }
  };

  return CourseOnlineCat;

};
