'use strict';

module.exports = app => {
  const router = app.router.namespace(app.config.projectRootPath + '/course/v5');
  // const miniAuth = app.middleware.miniAuthV5();// 因为不跟现有的用户中心系统，所以使用单独的登录中间件
  const auth = app.middleware.verifyAuth();

  router.post('third', '/verification_code', 'course.v5.user.sendVerificationCode');// 发送验证码
  router.post('third', '/login/phone', 'course.v5.user.loginByPhone');// 手机号登录
  router.post('third', '/login/wechat', 'course.v5.user.loginByWX');// 微信登录
  router.post('third', '/user/register_user', auth, 'course.v5.user.registerUserInfo');// 授权后注册用户
  router.get('third', '/user/info', auth, 'course.v5.user.getUserInfo');// 获取用户信息
  router.post('third', '/user/baby', auth, 'course.v5.user.addUserBaby');// 上传用户宝宝信息

  router.get('third', '/category/all', 'course.v5.option.getCategoryList');// 获取分类列表
  router.get('third', '/banner/all', 'course.v5.option.getBannerList');// 获取banner列表
  router.get('third', '/options', 'course.v5.option.getOptions');// 获取配置项
  router.post('third', '/wechat/qrcode', 'course.v5.wechat.getQRCode');// 获取二维码

  router.get('third', '/class/all', auth, 'course.v5.institution.getClassList');// 获取课程列表
  router.get('third', '/class/:class_id', auth, 'course.v5.institution.getClassInfo');// 获取课程详情

  router.get('/third', '/collection/class/all', auth, 'course.v5.institution.getCollectionClassList');// 获取收藏课程列表
  router.post('/third', '/collection/class/:class_id', auth, 'course.v5.institution.collectClass');// 收藏课程
};
