'use strict';

const Controller = require('egg').Controller;

class BlacklistController extends Controller {

    /**
     * 获取黑名单报告
     */
    async getBlacklistReport() {
        const { ctx } = this;
        let inputParams = ctx.params;
        if (!inputParams.report_id) {
            ctx.failed('empty report id');
        }
        let ret = await ctx.service.credit.blacklist.getReport(inputParams.report_id);
        ctx.success(ret);
    }


}

module.exports = BlacklistController;
