'use strict';

const Controller = require('egg').Controller;
const moment = require('moment');
const WECHAT_CODE_URL = 'https://open.weixin.qq.com/connect/oauth2/authorize';
const WECHAT_APPID = 'wx3c772df2d8d78da3';
const WECHAT_APPID_TEST = 'wxa9df2d60730b25d9';
const REDIRECT_PAGE = '/webserve/accumulation/index';
class WechatController extends Controller {


  // 公众号公积金查询H5授权跳转
  async oauthLogin() {

    const { ctx } = this;
    const code = ctx.query.code;
    const channel_id = ctx.query.channel_id;
    const app_id = [ 'https://lan-nginx.jianbing.com', 'https://pro-nginx.jianbing.com', 'https://p.jianbing.com', 'https://b.jianbing.com' ].includes(this.config.NODE_BASE_URL) ? WECHAT_APPID : WECHAT_APPID_TEST;
    if (!code || code.length === 0) {
      const target_url = WECHAT_CODE_URL + `?appid=${app_id}&redirect_uri=${encodeURIComponent(`${this.app.config.PULIC_BASE_URL}/51business/api/gjj/wechat/oauth_login?&channel_id=${channel_id}`)}&response_type=code&scope=snsapi_base&state=gjjquery#wechat_redirect`;
      ctx.redirect(target_url); return;
    }
    const oauth_url = `${this.config.NODE_BASE_URL}/user_api/v1/login/oauth_login`;// 用户中心授权地址
    // 授权参数
    const oauth_params = {
      login_type: '5', // 5代表微信授权登录  如果有QQ授权登录，再扩展
      app_user_id: '',
      code,
      token: '',
      app_id,
    };
    const result = await ctx.helper.send_request(oauth_url, oauth_params, { method: 'POST' });// 通过授权码code返回授权状态
    ctx.logger.info(JSON.stringify({ gjj_wechat_oauth_login_params: oauth_params, gjj_wechat_oauth_login_result: result }));

    const ret = result.data;
    if (result.status !== 201) { // 调用接口出错抛出异常
      const error_message = ret.error ? ret.error : '授权失败，请联系客服';
      ctx.failed(error_message);
    }

    const no_login_url = this.config.PULIC_BASE_URL + REDIRECT_PAGE + `?channel_id=${channel_id}&type=noLogin`;// 未登录并没有公积金数据的页面
    const detail_url = this.config.PULIC_BASE_URL + REDIRECT_PAGE + `?channel_id=${channel_id}&type=hasLogin`;// 已登录并且有公积金数据的公积金详情页，

    // { code: '-1', msg: 'APP用户状态异常' }
    // { code: '-2', msg: '需要重新授权' }
    // { code: '-3', msg: '需要先手机登录' }
    // { code: '-4', msg: '绑定失败，此QQ已绑定其他手机了'}
    if (ret.code && ret.code === '-3') { // 如果用户未绑定手机，先去做登录绑定手机号
      ctx.redirect(no_login_url);
      return;
    }
    if (!ret || ret.code !== '1' || !ret.data || !ret.data.openid) {
      const error_msg = ret.msg || '获取openid失败';
      ctx.failed(error_msg);
    }

    const openid = ret.data.openid;
    const login_result = await this.user_login({ code, openid, channel_id });// 用openid直接登录用户
    const user_id = login_result.user_id;

    // 已绑定手机的 继续 判断是否有导入公积金
    if (!login_result.token) {
      ctx.redirect(no_login_url + `?channel_id=${channel_id}&type=noLogin`); return;
    }
    const gjj_exist_url = `${this.app.config.NODE_BASE_URL}/cassandra-server/gjj/list/${user_id}`;
    const gjj_exist_result = await ctx.helper.send_request(gjj_exist_url, {}, { method: 'GET' });
    ctx.logger.info(JSON.stringify({ user_id, gjj_exist_result }));
    if (gjj_exist_result.status !== 200) { // 调用公积金接口出错
      ctx.redirect(no_login_url); return;
    }
    const gjj_exist_ret = gjj_exist_result.data;
    if (!gjj_exist_ret.ret || gjj_exist_ret.ret.length === 0) { // 没有导入公积金时
      ctx.redirect(no_login_url); return;
    }

    ctx.redirect(detail_url); return;// 已导入公积金
  }

  async checkLogin() {

    const { ctx } = this;
    const user_id = ctx.userId;
    let is_login = false;
    if (user_id) {
      is_login = true;
    }

    ctx.success({ result: is_login });
  }


  async user_login(params) {

    const { ctx } = this;
    const { code, openid, channel_id } = params;

    const user_agent = ctx.request.header.user_agent ? ctx.request.header.user_agent : 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36';
    const ip = ctx.helper.getClientIP();
    const past_deviceno = ctx.helper.md5(user_agent + ip);

    const app_channel_info = await ctx.blockModel.AppChannel.one({ where: { alias: channel_id } });
    if (!app_channel_info || Object.keys(app_channel_info).length === 0) {
      ctx.failed('渠道未配置');
    }
    if (!app_channel_info.app_id) {
      ctx.failed('渠道未关联APPID');
    }

    const device_login_params = {// 设备登录的参数
      past_deviceno,
      channel_id: app_channel_info.channel_id,
      app_id: app_channel_info.app_id,
      device_info: {},
    };
    // 设备登录
    const result_device_login = await ctx.helper.send_request(this.config.NODE_URL + '/login/device', device_login_params, { method: 'POST' });// 设备登录
    const device_login_data = result_device_login.data;// 设备登录返回结果
    if (!device_login_data || Object.keys(device_login_data).length === 0) {
      ctx.failed('device login error, device_login_data empty');
    }
    if (!device_login_data.past_deviceno) { // 使用设备码+时间+随机数产生的一个尽量避免重复的字符串，类似游客版h5
      ctx.failed('device login error, past_deviceno empty');
    }
    if (!device_login_data.device_id) { // Devices字段表主键ID
      ctx.failed('device login error, device_id empty');
    }
    if (!device_login_data.device_login_logs_id) { // DeviceLoginLogs字段表主键ID
      ctx.failed('device login error, device_login_logs_id empty');
    }

    const user_login_params = {// 用户登录传递的参数
      past_deviceno, // 使用设备码+时间+随机数产生的一个尽量避免重复的字符串，类似游客版h5登
      // device_no: device_login_data.device_no,//使用新的sdk生成的设备指纹
      login_type: '5', // 登录类型：1 验证码手机登录, 2 password手机登录,4 token登录,5 微信登录,
      passport: code, // 登录账号：手机登录值为手机
      password: code, // 类型对应的值
      app_user_id: params.app_user_id || '', // app用户ID token登陆时传的参数  可空
      code: code || '', // 第三方授权登录时的code  可空
      device_info: {}, // 设备信息
      openid: openid || '', // 例如微信公众号的openid（不传默认是51查个税）
    };
    const result_user_login = await ctx.helper.send_request(this.config.NODE_URL + '/login/user', user_login_params, { method: 'POST' });// 用户登录
    ctx.logger.info(JSON.stringify({ user_ologin_params: user_login_params, result_user_ologin: result_user_login }));
    const user_login_data = result_user_login.data;// 用户登录返回结果
    if (!user_login_data || Object.keys(user_login_data).length === 0) {
      ctx.failed('用户的登录失败');
    }
    if (!user_login_data.token || !user_login_data.uid || !user_login_data.app_user_id) {
      const error_msg = user_login_data.error ? user_login_data.error : '用户的openid登录失败';
      ctx.failed(error_msg);
    }
    // 获取用户信息
    const login_token = user_login_data.token;
    const app_user_id = user_login_data.app_user_id;
    const user_id = user_login_data.uid;
    const device_id = device_login_data.device_id;
    const device_login_id = device_login_data.device_login_logs_id;

    // 老版用户信息
    const old_user_sid = user_login_data.old_uid;
    let auth_token = '';
    if (old_user_sid) {
      auth_token = ctx.helper.md5(String(old_user_sid) + moment(new Date()).format('MDYYYY') + 'f74jkdsy83sjf', 'utf8');
    }

    // 需要存cookie的用户信息
    const user_info = {
      token: login_token,
      app_user_id,
      user_id,
      device_id,
      device_login_id,
      android_url: `${this.config.OUT_P_NODE_URL}/frontendh5/lp/wc/index?down=${encodeURIComponent(app_channel_info.android_url)}`,
      ios_url: app_channel_info.ios_url,
      jianbing_customer_id: old_user_sid,
      auth_token,
    };
    for (const key in user_info) { // 保存cookie
      const value = user_info[key];
      ctx.cookies.set(key, value, { httpOnly: false, signed: false, path: '/', overwrite: true });
    }

    return user_info;

  }
}
module.exports = WechatController;
