'use strict';
const xml2js = require('xml2js');

const Controller = require('egg').Controller;
class TestController extends Controller {
  async test() {
    this.ctx.set('content-type', 'text/xml');
    const data = {
      MsgType: 'transfer_customer_service',
      ToUserName: 'to',
      FromUserName: 'from',
      CreateTime: parseInt(new Date() / 1000),
    };
    const builder = new xml2js.Builder({ rootName: 'xml' });
    let xml = builder.buildObject(data);
    xml = '<xml><ToUserName><![CDATA[$openid]]></ToUserName><FromUserName><![CDATA[$appId]]></FromUserName><CreateTime>$createTine</CreateTime><MsgType><![CDATA[transfer_customer_service]]></MsgType></xml>';
    this.ctx.body = xml;
  }
}
module.exports = TestController;
