'use strict';

const Controller = require('egg').Controller;

class LocationController extends Controller {

  /**
     * 筛选项
     */
  async getAddress() {

    const { ctx } = this;
    let { lat, lng } = ctx.request.body;
    let address = '';
    if (lat && lng) {
      const location_ret = await ctx.service.course.v4.lbs.getLBSLocation({ lat, lng });
      const loaction = location_ret.result;
      if (loaction.formatted_addresses && loaction.formatted_addresses.recommend) {
        address = loaction.formatted_addresses.recommend;
        lat = loaction.location.lat;
        lng = loaction.location.lng;
      }
    }
    if (!address) {
      const ip_ret = await ctx.service.course.v4.lbs.getLBSIp();
      const ip = ip_ret.result;
      if (ip.location && ip.ad_info) {
        const city = ip.ad_info.city ? ip.ad_info.city : '';
        const district = ip.ad_info.district ? ip.ad_info.district : '';
        address = ip.ad_info.province + city + district;
        lat = ip.location.lat;
        lng = ip.location.lng;
      }
    }
    if (!address) {
      address = '获取地理位置信息失败';
    }
    ctx.success({ result: { address, lat, lng } });
  }

}

module.exports = LocationController;
