'use strict';


const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE, TEXT } = app.Sequelize;

  const CourseV5Institution = app.classModel.define('course_v5_institution', {
    id: {
      type: INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    relation_id: INTEGER,
    name: STRING,
    logo: STRING,
    description: TEXT,
    title: STRING,
    pay_column: STRING,
    back_column: STRING,
    status: INTEGER,
    is_deleted: INTEGER,
    created_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('created_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    updated_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('updated_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'course_v5_institution',
  });

  return CourseV5Institution;

};
