'use strict';
module.exports = () => {
  return async function deviceInit(ctx, next) {

    const method = ctx.request.method;
    let input_params = {};
    switch (method) {
      case 'GET':
        input_params = ctx.request.query;
        break;
      case 'POST':
        input_params = ctx.request.body;

        break;
      case 'PUT':
        input_params = ctx.request.body;
        break;
      default:
        break;
    }

    const stack = ctx.app.router.stack;
    const current_path_list = ctx.request.url.split('?');
    const current_path = current_path_list[0];

    let current_url_eq_path = 1;
    for (const element in stack) {

      const path_index = stack[element].path.split(':');
      const path = path_index[0];
      current_url_eq_path = current_path.includes(path) ? 1 : 0;

      if (current_url_eq_path == 1 && stack[element].name != null && stack[element].methods.includes(ctx.request.method)) {
        if (input_params.app_user_id != undefined) {
          ctx.setAppUserId(input_params.app_user_id);
        }

        if (input_params.device_id != undefined) {
          ctx.setDeviceId(input_params.device_id);
        }

        if (input_params.device_login_id != undefined) {
          ctx.setDeviceLoginId(input_params.device_login_id);
        }

        await next();
        return;
      }
    }

    // 优先从cookie中取，取不到再从header中取
    let appUserId = ctx.cookies.get('app_user_id', { signed: false });
    let token = ctx.cookies.get('token', { signed: false });
    let userId = ctx.cookies.get('user_id', { signed: false });
    let deviceId = ctx.cookies.get('device_id', { signed: false });
    let deviceLoginId = ctx.cookies.get('device_login_id', { signed: false });
    let appTypeId = '2150d0f1-ee07-4d17-a019-251be3699bd1';
    let appId = 'DE78A9AC-0407-4998-AE4D-B7F5A64EAC19';
    let oldUserId;

    if (!deviceId || deviceId.length === 0) {
      deviceId = ctx.deviceId;
    }

    if (!deviceLoginId || deviceLoginId.length === 0) {
      deviceLoginId = ctx.deviceLoginId;
    }

    if (!appUserId || appUserId.length === 0) {
      appUserId = typeof (ctx.request.header.app_user_id) !== 'undefined' ? ctx.request.header.app_user_id : undefined;
    }
    if (!token || token.length === 0) {
      token = typeof (ctx.request.header.token) !== 'undefined' ? ctx.request.header.token : undefined;
    }
    if (!userId || userId.length === 0) {
      userId = typeof (ctx.request.header.uid) !== 'undefined' ? ctx.request.header.uid : undefined;
    }

    if (!deviceId || deviceId.length === 0) {
      deviceId = typeof (ctx.request.header.device_id) !== 'undefined' ? ctx.request.header.device_id : undefined;
    }

    if (!deviceLoginId || deviceLoginId.length === 0) {
      deviceLoginId = typeof (ctx.request.header.device_login_id) !== 'undefined' ? ctx.request.header.device_login_id : undefined;
    }

    // if ((deviceId == undefined || !deviceId || deviceId.length === 0) && input_params.device_id != undefined) {
    //   deviceId = input_params.device_id;
    // }
    // 校验
    const params = {
      app_user_id: appUserId,
      token,
      uid: userId,
      device_id: deviceId,
      device_login_id: deviceLoginId,
    };

    const result = await ctx.helper.send_request(ctx.app.config.NODE_URL + '/user_api/v1/user/auth', params, {
      method: 'POST',
    });
    // ctx.logger.info('appUserId: ' + appUserId);
    ctx.logger.info('request_header: ' + JSON.stringify(ctx.request.header));
    ctx.logger.info('user_auth_params: ' + JSON.stringify(params));
    ctx.logger.info('user_auth_result: ' + JSON.stringify(result));
    console.log(result);
    // if (result.status !== 201) {
    //   ctx.failed('无效用户');
    //   return;
    // }

    //  const data = result.data.data;
    let data = result.data.data;
    if (result.data == undefined || result.data.data == undefined) {
      data = {};
    }
    // const data = {};
    // 所有数据以校验后返回的为准
    appUserId = data.app_user_id || undefined;
    userId = data.uid || undefined;
    deviceId = data.device_id || undefined;
    deviceLoginId = data.device_login_logs_id || undefined;
    appId = data.app_id || undefined;
    appTypeId = data.app_type_id || undefined;
    oldUserId = data.oid || undefined;


    // 写入常量
    ctx.setAppUserId(appUserId);
    ctx.setUserId(userId);
    ctx.setDeviceId(deviceId);
    ctx.setDeviceLoginId(deviceLoginId);
    ctx.setAppId(appId);
    ctx.setAppTypeId(appTypeId);
    ctx.setOldUserId(oldUserId);

    // 设置旧cookie
    let authToken = '';
    if (oldUserId) {
      const moment = require('moment');
      authToken = ctx.helper.md5(String(oldUserId) + moment(new Date()).format('MDYYYY') + 'f74jkdsy83sjf', 'utf8');
    }
    ctx.setOldCookie('jianbing_customer_id=' + oldUserId + ';auth_token=' + authToken);

    await next();

  };
};
