'use strict';

const Controller = require('egg').Controller;

class CallriskController extends Controller {

    /**
     * 通话记录风险检测报告
     */
    async getReport() {

        const { ctx } = this;
        const report_id = ctx.params.report_id;
        if (!report_id) {
            ctx.failed('error report id');
        }
        const result = await ctx.service.credit.callrisk.getReport(report_id);
        ctx.success({ result });

    }

    /**
     * 进入个人通话风险检测页面
     */
    async callriskInit() {
        const { ctx } = this;
        const result = await ctx.service.credit.apply.callriskInit();
        ctx.success({ result });
    }

    /**
     * 立即检测
     */
    async applyCallriskReport() {

        const { ctx } = this;
        const input_params = ctx.request.body;
        const rule = {
            name: { type: 'string', required: true },
            phone: { type: 'string', required: true },
            id_card: { type: 'string', required: true },
            password: { type: 'string', required: true },
            net: { type: 'string', required: true },
        }
        ctx.validate(rule, input_params);
        const result = await ctx.service.credit.apply.applyCallrisk(input_params);
        ctx.success({ result });

    }

    async getCode() {

        const { ctx } = this;
        const order_id = ctx.request.body.order_id;
        const result = await ctx.service.credit.callrisk.getCode(order_id);
        ctx.success({ result });

    }

    async commitTask() {

        const { ctx } = this;
        const { order_id, code } = ctx.request.body;
        const result = await ctx.service.credit.callrisk.commitTask({ order_id, code });

        ctx.success({ result });
    }

    async queryTaskStatus() {

        const { ctx } = this;
        const order_id = ctx.params.order_id;
        const result = await ctx.service.credit.callrisk.queryTaskStatus(order_id);

        ctx.success({ result });
    }


}

module.exports = CallriskController;
