
'use strict';

const Service = require('egg').Service;
const moment = require('moment');

class CollectionService extends Service {

    /**
     * 添加收藏
     * @param {object} inputParams 
     */
    async addCollection(inputParams) {
        const { ctx, service } = this;

        let filter = {
            pageIndex: 1,
            pageSize: 999,
            queryConditions: [{
                key: "state",
                value: 1,
                operator: "equal"
            }, {
                key: "userId",
                value: ctx.userId,
                operator: "equal"
            }, {
                key: "connectId",
                value: inputParams.id,
                operator: "equal"
            }, {
                key: "houseStyle",
                value: inputParams.type,
                operator: "equal"
            },
            ],
            orderConditions: [],
        }
        let collectionHistory = await service.houseCommon.collection.all(filter);
        if (collectionHistory.rowCount > 0) {
            ctx.failed('已经关注过啦');
        }
        let data = {
            userId: ctx.userId,
            appUserId: ctx.appUserId,
            houseStyle: inputParams.type,
            connectId: inputParams.id,
            state: 1,
            remark: inputParams.remark || ''
        }
        let ret = await service.houseCommon.collection.add(data);
        return { id: ret.id };
    }


    /**
     * 获取收藏列表  保留最近6个月的记录，条数不超过50条
     * @param {object} condition 
     */
    async getCollectionList() {
        const { ctx, service } = this;
        let endDate = moment().subtract(180, 'days').format('YYYY-MM-DD HH:mm:ss');
        let filter = {
            pageIndex: 1,
            pageSize: 50,
            queryConditions: [{
                key: "state",
                value: 1,
                operator: "equal"
            }, {
                key: "userId",
                value: ctx.userId,
                operator: "equal"
            },
                //  {
                //     key: "createdAt",
                //     value: endDate,
                //     operator: "greater"
                // },
            ],
            orderConditions: [{
                key: 'createdAt',
                orderSequence: 'desc',
            },],
        }

        let list = [];
        let collectionList = await service.houseCommon.collection.all(filter);
        if (collectionList.rowCount > 0) {
            //整理所有收藏
            let taskList = [];
            for (let i in collectionList.results) {
                if (collectionList.results[i].houseStyle === 1) {
                    taskList[i] = service.houseCommon.newHouse.one(collectionList.results[i].connectId);
                } else {
                    taskList[i] = service.houseCommon.rentalHouse.one(collectionList.results[i].connectId);
                }
            }

            let retList = await Promise.all(taskList).then(result => {
                return result;
            }).catch(error => {
                ctx.failed(error);
            });
            //数据整理
            for (let j in retList) {
                let type = collectionList.results[j].houseStyle;
                let tmp = {
                    id: retList[j].id,
                    name: retList[j].name,
                    address: retList[j].address,
                    tags: retList[j].tags.split(','),
                    image: retList[j].image,
                    area: type === 1 ? retList[j].houseArea : '',
                    price: type === 1 ? retList[j].referenceAvgPrice : retList[j].price,
                    type: type === 1 ? 'new_house' : 'rental_house',
                };
                list.push(tmp);
            }
        }
        let ret = {
            results: list,
            count: list.length
        };
        return ret;
    }


}

module.exports = CollectionService;
