'use strict';

const Controller = require('egg').Controller;

class LotteryPubliciseController extends Controller {
    /**
     * 用户输入楼盘的名字模糊匹配所有的楼盘
     */
    async getHouseName() {
        const { ctx } = this;
        let inputParams = ctx.request.body;
        let rule = {
            name: { type: 'string', required: true },
        };
        ctx.validate(rule, inputParams);
        let ret = await ctx.service.cd.lotteryPublicise.getHouseName(inputParams.name);
        ctx.success(ret);
    }


}

module.exports = LotteryPubliciseController;
