'use strict';

const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE } = app.Sequelize;
  const WechatApp = app.huodongModel.define('wechat_app', {
    id: { type: INTEGER, primaryKey: true, autoIncrement: true },
    name: STRING,
    ident: STRING,
    appid: STRING,
    appsecret: STRING,
    business_url: STRING,
    login_url: STRING,
    status: INTEGER,
    created_at: {
      type: DATE,
      get() {
        const date = this.getDataValue('created_at');
        return (date && date.toString() !== 'Invalid Date') ? moment(date).format('YYYY-MM-DD HH:mm:ss') : '0000-00-00 00:00:00';
      },
    },
    updated_at: {
      type: DATE,
      get() {
        const date = this.getDataValue('updated_at');
        return (date && date.toString() !== 'Invalid Date') ? moment(date).format('YYYY-MM-DD HH:mm:ss') : '0000-00-00 00:00:00';
      },
    },
  }, {
    timestamps: false,
    tableName: 'wechat_app',
  });

  return WechatApp;
};
