'use strict';

const Controller = require('egg').Controller;

class OptionController extends Controller {

  /**
     * 筛选项
     */
  async getOptions() {

    const { ctx } = this;
    const results = await ctx.service.course.v2.option.getOptions();

    ctx.success({ results });
  }

  async getBanners() {
    const { ctx, service } = this;
    const inputParams = ctx.request.query;
    if (ctx.isEmpty(inputParams.alias)) {
      ctx.failed('alias is empty');
    }
    const ret = await service.course.v2.option.getBanners(inputParams.alias);

    ctx.success(ret);
  }

}

module.exports = OptionController;
