'use strict';

const Controller = require('egg').Controller;

class FootPrintController extends Controller {

    /**
     * 获取足迹列表
     */
    async getFootPrintList() {
        const { ctx } = this;
        let ret = await ctx.service.house.v2.footPrint.getFootPrintList();
        ctx.success(ret);
    }


    /**
     * 海外房的足迹记录需要额外记录
     */
    async addAbroadFootPrint() {
        const { ctx } = this;
        let inputParams = ctx.request.body;
        const rule = {
            id: { type: 'int', required: true },
        };
        ctx.validate(rule, inputParams);
        inputParams.type = 4;
        let ret = await ctx.service.house.v2.footPrint.addFootPrint(inputParams);
        ctx.success(ret);
    }

}

module.exports = FootPrintController;
