'use strict';

const moment = require('moment');

module.exports = app => {
    const { STRING, INTEGER, DATE } = app.Sequelize;
    const NewHouseCityPrice = app.realestateModel.define('new_house_city_price', {
        id: {
            type: INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true,
        },
        city: {
            type: STRING,
            allowNull: true
        },
        code: {
            type: INTEGER,
            allowNull: true
        },
        price: {
            type: INTEGER,
            allowNull: true
        },
        valid: {
            type: INTEGER,
            allowNull: true
        },
    }, {
            timestamps: false,
            tableName: 'new_house_city_price',
        });


    return NewHouseCityPrice;

};
