'use strict';

const Controller = require('egg').Controller;

class InstitutionController extends Controller {

  // 机构列表
  async getInstitutions() {

    const { ctx } = this;
    const inputParams = ctx.request.query;
    const ret = await ctx.service.course.v3.institution.getInstitutions(inputParams);

    ctx.success(ret);
  }

  // 机构详情
  async getInstitution() {

    const { ctx } = this;
    let inputParams = ctx.params;
    const query = ctx.query;
    inputParams = Object.assign(inputParams, query);
    const result = await ctx.service.course.v3.institution.getInstitution(inputParams);

    ctx.success({ result });
  }

  // 课程列表
  async getClasses() {

    const { ctx } = this;
    const inputParams = ctx.request.query;
    const ret = await ctx.service.course.v3.institution.getClasses(inputParams);

    ctx.success(ret);
  }

  // 课程详情
  async getClass() {

    const { ctx } = this;
    const class_id = ctx.params.class_id;
    if (!class_id) {
      ctx.failed('error class_id');
    }
    const ret = await ctx.service.course.v3.institution.getClass(class_id);

    ctx.success(ret);
  }

  // 老师列表
  async getTeachers() {

    const { ctx } = this;
    const inputParams = ctx.request.query;
    if (ctx.isEmpty(inputParams.institution_id)) {
      ctx.failed('institution_id is empty');
    }
    const ret = await ctx.service.course.v3.institution.getTeachers(inputParams);

    ctx.success(ret);
  }

  // 老师详情
  async getTeacher() {

    const { ctx } = this;
    const teacher_id = ctx.params.teacher_id;
    if (!teacher_id) {
      ctx.failed('error teacher_id');
    }
    const ret = await ctx.service.course.v3.institution.getTeacher(teacher_id);

    ctx.success(ret);
  }

  // 获取分类
  async getCats() {
    const { ctx } = this;

    const ret = await ctx.service.course.v3.institution.getCats();

    ctx.success(ret);
  }

  // 搜索
  async search() {

    const { ctx } = this;
    const inputParams = ctx.request.query;
    const ret = await ctx.service.course.v3.institution.search(inputParams);

    ctx.success(ret);
  }

  // 用户搜索历史
  async getUserSearch() {
    const { ctx, service } = this;
    const ret = await service.course.v3.institution.getUserSearch();

    ctx.success(ret);
  }

  // 获取热搜
  async getHotSearch() {
    const { ctx, service } = this;
    const ret = await service.course.v3.institution.getHotSearch();

    ctx.success(ret);
  }

  // 删除用户搜索历史
  async deleteUserSearch() {
    const { ctx, service } = this;
    await service.course.v3.institution.deleteUserSearch();

    ctx.success();
  }

  // 评论列表
  async getComments() {
    const { ctx, service } = this;
    const inputParams = ctx.request.query;
    const ret = await service.course.v3.institution.getComments(inputParams);

    ctx.success(ret);
  }

  // 搜索联想
  async getSuggestSearch() {
    const { ctx, service } = this;
    const inputParams = ctx.request.query;
    const ret = await service.course.v3.institution.getSuggestSearch(inputParams);

    ctx.success(ret);
  }

  // 用户收藏机构列表
  async getUserCollectedInstitutions() {
    const { ctx, service } = this;
    const inputParams = ctx.request.query;
    const ret = await service.course.v3.institution.getUserCollectedInstitutions(inputParams);

    ctx.success(ret);
  }
}

module.exports = InstitutionController;
