'use strict';

const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE, ENUM } = app.Sequelize;
  const RecommendChannelOption = app.blockModel.define('recommend_channel_option', {
    id: { type: INTEGER, primaryKey: true, autoIncrement: true },
    title: STRING,
    classify_id: INTEGER,
    order: INTEGER,
    status: ENUM('offline', 'online'),
    valid: INTEGER,
    // 注意，需要转成string
    created_at: {
      type: DATE,
      get() {
        const date = this.getDataValue('created_at');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    updated_at: {
      type: DATE,
      get() {
        const date = this.getDataValue('updated_at');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'recommend_channel_option',
  });

  RecommendChannelOption.one = async data => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await RecommendChannelOption.findOne({
      attributes,
      where,
    });
  };


  RecommendChannelOption.all = async data => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await RecommendChannelOption.findAll({
      attributes,
      where,
    });
  };

  RecommendChannelOption.list = async (data = {}) => {
    const limit = data.limit ? data.limit : 10;
    const page = data.page ? data.page : 1;
    const order = data.order ? data.order : [];
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const condition = {
      offset: (page - 1) * limit,
      limit,
      where,
      order,
      attributes,
    };
    const { count, rows } = await RecommendChannelOption.findAndCountAll(condition);
    return { page, count, rows };
  };

  RecommendChannelOption.add = async data => {
    try {
      // 返回promise对象实力 instance
      const res = await RecommendChannelOption.create(data);
      // 从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
      return res.id;
    } catch (error) {
      ctx.status = 500;
      throw (error);
    }
  };

  RecommendChannelOption.edit = async data => {
    const where = data.where;
    const params = data.params;
    RecommendChannelOption.update(params, {
      where,
    }).catch(e => res.json({ status: 500, error: e }));
  };

  return RecommendChannelOption;

};
