'use strict';

const Controller = require('egg').Controller;

class ReportController extends Controller {
  // 获取问题列表
  async getQuestionList() {
    const { ctx, service } = this;
    const queryParams = ctx.request.query;
    if (ctx.isEmpty(queryParams) || ctx.isEmpty(queryParams.cat_id)) {
      ctx.failed('cat_id is empty');
    }

    const ret = await service.course.v5.report.getQuestionList(queryParams.cat_id);
    ctx.success(ret);
  }

  // 生成报告
  async generateReport() {
    const { ctx, service } = this;
    const queryParams = ctx.request.body;
    if (ctx.isEmpty(queryParams) || ctx.isEmpty(queryParams.data)) {
      ctx.failed('data is empty');
    }
    if (ctx.isEmpty(queryParams) || ctx.isEmpty(queryParams.cat_id)) {
      ctx.failed('cat_id is empty');
    }

    const ret = await service.course.v5.report.generateReport(queryParams);
    ctx.success(ret);
  }

  // 获取报告详情
  async getReportById() {
    const { ctx, service } = this;
    const params = ctx.params;
    if (ctx.isEmpty(params) || ctx.isEmpty(params.report_id)) {
      ctx.failed('report_id is empty');
    }

    const ret = await service.course.v5.report.getReportById(params.report_id);
    ctx.success(ret);
  }

  // 获取报告列表
  async getReportList() {
    const { ctx, service } = this;

    const ret = await service.course.v5.report.getReportList();
    ctx.success(ret);
  }
}

module.exports = ReportController;
