'use strict';

const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE } = app.Sequelize;
  const Message = app.huodongModel.define('cfg_message', {
    id: { type: STRING, primaryKey: true },
    title: STRING,
    content: STRING,
    url: STRING,
    image: STRING,
    send_time: {
      type: DATE,
      get() {
        const date = this.getDataValue('send_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    msg_type: INTEGER,
    msg_push_type: INTEGER,
    app_id: STRING,
    app_type_id: STRING,
    show_type: INTEGER,
    valid: INTEGER,
    end_time: DATE,
  }, {
    timestamps: false,
    tableName: 'cfg_message',
  });

  Message.one = async data => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await Message.findOne({
      attributes,
      where,
    });
  };


  Message.all = async data => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await Message.findAll({
      attributes,
      where,
    });
  };

  Message.list = async (data = {}) => {
    const limit = data.limit ? data.limit : 10;
    const page = data.page ? data.page : 1;
    const order = data.order ? data.order : [];
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const condition = {
      offset: (page - 1) * limit,
      limit,
      where,
      order,
      attributes,
    };
    console.log(condition);
    const { count, rows } = await Message.findAndCountAll(condition);
    return { page, count, rows };
  };

  Message.add = async data => {
    try {
      // 返回promise对象实力 instance
      const res = await Message.create(data);
      // 从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
      return res.id;
    } catch (error) {
      this.ctx.status = 500;
      throw (error);
    }
  };

  Message.edit = async data => {
    const where = data.where;
    const params = data.params;
    Message.update(params, {
      where,
    }).catch(e => res.json({ status: 500, error: e }));
  };

  return Message;

};
