
'use strict';

const Service = require('egg').Service;
const R = require('ramda');
const PRICE_RANGE = [
    { name: '不限', id: -100, min: 0, max: 0 },
    { name: '2000元以下', id: -101, min: 0, max: 2000 },
    { name: '2000元-3000元', id: -102, min: 2000, max: 3000 },
    { name: '3000元-4000元', id: -103, min: 3000, max: 4000 },
    { name: '4000元-5000元', id: -104, min: 4000, max: 5000 },
    { name: '5000元-6000元', id: -105, min: 5000, max: 6000 },
    { name: '6000元-7000元', id: -106, min: 6000, max: 7000 },
    { name: '7000元-8000元', id: -107, min: 7000, max: 8000 },
    { name: '8000元-10000元', id: -108, min: 8000, max: 10000 },
    { name: '10000元以上', id: -109, min: 10000, max: 10000000000000 },
]

const HOUSE_TYPE = [
    { name: '不限', id: -110, min: 0, max: 0, value: 0, },
    { name: '1室', id: -111, min: 1, max: 1, value: 1, },
    { name: '2室', id: -112, min: 2, max: 2, value: 2, },
    { name: '3室', id: -113, min: 3, max: 3, value: 3, },
    { name: '4室', id: -114, min: 4, max: 4, value: 4, },
    { name: '5室', id: -115, min: 4, max: 4, value: 5, },
    { name: '5室以上', id: -116, min: 5, max: 10000, value: 6, },
    // { name: '别墅', id: -117, min: 10000, max: 10000000, value: 7, },
]

const NEW_HOUSE_UNIT_PRICE = [
    { name: '不限', id: -118, min: 0, max: 0 },
    { name: '1万以下', id: -119, min: 0, max: 10000 },
    { name: '1万-2万', id: -120, min: 10000, max: 20000 },
    { name: '2万-3万', id: -121, min: 20000, max: 30000 },
    { name: '3万-4万', id: -122, min: 30000, max: 40000 },
    { name: '4万-5万', id: -123, min: 40000, max: 50000 },
    { name: '5万-6万', id: -124, min: 50000, max: 60000 },
]

const NEW_HOUSE_TOTAL_PRICE = [
    { name: '不限', id: -125, min: 0, max: 0 },
    { name: '100万以下', id: -126, min: 0, max: 100 },
    { name: '100万-200万', id: -127, min: 100, max: 200 },
    { name: '200万-300万', id: -128, min: 200, max: 300 },
    { name: '300万-400万', id: -129, min: 300, max: 400 },
    { name: '400万-500万', id: -130, min: 400, max: 500 },
    { name: '500万-600万', id: -131, min: 500, max: 600 },
    { name: '600万-700万', id: -132, min: 600, max: 700 },
    { name: '700万-800万', id: -133, min: 700, max: 800 },
    { name: '800万-900万', id: -134, min: 800, max: 900 },
    { name: '900万-1000万', id: -135, min: 900, max: 1000 },
    { name: '1000万以上', id: -136, min: 1000, max: 999999999 },
]

const NEW_HOUSE_AREA = [
    { name: '不限', id: -137, min: 0, max: 0 },
    { name: '50平米以下', id: -138, min: 0, max: 50 },
    { name: '50平米-70平米', id: -139, min: 50, max: 70 },
    { name: '70平米-90平米', id: -140, min: 70, max: 90 },
    { name: '90平米-120平米', id: -141, min: 90, max: 120 },
    { name: '120平米-150平米', id: -142, min: 120, max: 150 },
    { name: '150平米-200平米', id: -143, min: 150, max: 200 },
    { name: '200平米以上', id: -144, min: 200, max: 999 }
]

const NEW_HOUSE_LOAN_TYPE = [
    { name: '全部', id: -146, values: 0 },
    { name: '可公积金贷款', id: -147, values: 1 },
];

class OptionService extends Service {

    //获取筛选项
    async getOptions(city_code) {

        let brands = await this.getDevelopers(city_code);
        brands.unshift({ id: -145, name: '不限', image: '', value: 0 });
        const house_types = HOUSE_TYPE;
        const prices = PRICE_RANGE;
        const areas = await this.getAreaOptions(city_code);

        return {
            result: [
                { name: '品牌', id: -1, path: [], nameShow: '', _children: brands },
                { name: '区域', id: -2, path: [], nameShow: '', _children: areas },
                { name: '价格', id: -3, path: [], nameShow: '', _children: prices },
                { name: '户型', id: -4, path: [], nameShow: '', _children: house_types }
            ]
        };
    }

    //获取新房的筛选项
    async getNewHouseOptions(city_code) {

        const unit_price = NEW_HOUSE_UNIT_PRICE;
        const total_price = NEW_HOUSE_TOTAL_PRICE;
        const house_types = HOUSE_TYPE;
        const house_area = NEW_HOUSE_AREA;
        const loan_type = NEW_HOUSE_LOAN_TYPE;
        const areas = await this.getAreaOptions(city_code);

        return {
            result: [
                { name: '区域', id: -1, path: [], nameShow: '', _children: areas },
                {
                    name: '价格', id: -2, path: [], nameShow: '', _children: [
                        { name: '总价', id: -3, _children: total_price },
                        { name: '单价', id: -4, _children: unit_price }]
                },
                { name: '面积', id: -5, path: [], nameShow: '', _children: house_area },
                // { name: '户型', id: -6, path: [], nameShow: '', _children: house_types },
                { name: '贷款方式', id: -6, path: [], nameShow: '', _children: loan_type },
            ]
        };
    }

    //获取开发商列表
    async getDevelopers(city_code) {

        const { ctx } = this;
        const rental_house_developers = await ctx.realestateModel.RentalHouse.findAll({ attributes: ['developer_id'], group: 'developer_id', where: { option_city_code: city_code, status: 'online', valid: 1 } });
        const developers_ids = rental_house_developers.map(item => { return item.developer_id });
        const developers = await ctx.realestateModel.Developer.all({ where: { id: { $in: developers_ids }, status: 'online', valid: 1 } });
        const ret = developers.map(item => { return { id: item.id, name: item.name, image: item.logo, value: item.id } });
        return ret;
    }

    //获取区域商圈
    async getAreaOptions(city_code) {
        const { ctx } = this;
        const city = await ctx.blockModel.City.one({ where: { code: city_code } });
        if (!city || !city.name) {
            ctx.failed('city code error');
        }
        const districts = await ctx.blockModel.HouseDistrict.all({ where: { city_id: city.code } });
        if (!districts || districts.length === 0) {
            return [];
        }

        const ret = [{ id: 0, name: '不限' }];
        for (let j in districts) {
            const district = districts[j];
            const _children = [{ id: 0, name: '不限' }];
            const bizcircles = await ctx.blockModel.HouseBizcircle.all({ where: { district_id: district.id } });
            if (!bizcircles || bizcircles.length === 0) {
                continue;
            }
            for (let i in bizcircles) {
                const bizcircle = bizcircles[i];
                _children.push({
                    id: bizcircle.id,
                    name: bizcircle.name,
                    value: bizcircle.id,
                    // district_id: bizcircle.district_id,
                });
            }
            ret.push({
                id: district.id,
                name: district.name,
                // city_id: district.city_id,
                _children: _children,
                value: district.id,
            })

        }

        return ret;
    }
}

module.exports = OptionService;
