'use strict';

module.exports = app => {
  const router = app.router.namespace(app.config.projectRootPath + '/course/v3');
  const loginAuth = app.middleware.loginAuth({ type: 'new' });// 登录中间件
  const miniAuth = app.middleware.miniAuthV3();// 因为不跟现有的用户中心系统，所以使用单独的登录中间件

  // 版本二
  router.get('third', '/cats', 'course.v3.institution.getCats');// 分类
  router.get('third', '/options', 'course.v3.option.getOptions');// 筛选项
  router.get('third', '/banners', 'course.v3.option.getBanners');// banner
  router.post('third', '/address', miniAuth, 'course.v3.location.getAddress');// 根据经纬度或ip获取地理位置信息
  router.get('third', '/institutions', miniAuth, 'course.v3.institution.getInstitutions');// 机构列表
  router.get('third', '/institution/:institution_id', miniAuth, 'course.v3.institution.getInstitution');// 机构详情
  router.get('third', '/classes', miniAuth, 'course.v3.institution.getClasses');// 课程列表
  router.get('third', '/class/:class_id', miniAuth, 'course.v3.institution.getClass');// 课程详情
  router.get('third', '/teachers', miniAuth, 'course.v3.institution.getTeachers');// 老师列表
  router.get('third', '/teacher/:teacher_id', miniAuth, 'course.v3.institution.getTeacher');// 老师详情

  router.post('third', '/user/auth', 'course.v3.user.auth');// 微信授权登录
  router.post('third', '/user/register_user', miniAuth, 'course.v3.user.registerUserInfo');// 授权后注册用户
  router.get('third', '/user/info', miniAuth, 'course.v3.user.getUserInfo');// 获取用户信息

  router.get('third', '/user/baby', miniAuth, 'course.v3.user.getBabyInfo');// 获取baby信息
  router.post('third', '/user/baby', miniAuth, 'course.v3.user.saveBabyInfo');// 保存baby信息
  router.delete('third', '/user/baby', miniAuth, 'course.v3.user.delBabyInfo');// 删除baby信息

  router.get('third', '/user/collection/institution', miniAuth, 'course.v3.institution.getUserCollectedInstitutions');// 收藏的机构列表
  router.get('third', '/user/collection/class', miniAuth, 'course.v3.institution.getUserCollectedClasses');// 收藏的课程列表
  router.post('third', '/user/collection/institution', miniAuth, 'course.v3.user.collectInstitution');// 收藏机构
  router.delete('third', '/user/collection/institution', miniAuth, 'course.v3.user.delCollectInstitution');// 取消收藏机构
  router.post('third', '/user/collection/class', miniAuth, 'course.v3.user.collectClass');// 收藏课程
  router.delete('third', '/user/collection/class', miniAuth, 'course.v3.user.delCollectClass');// 取消收藏课程

  router.get('third', '/wechat/callbackAction', 'course.v3.wechat.check');
  router.post('third', '/wechat/callbackAction', 'course.v3.wechat.callbackAction');
  router.post('third', '/wechat/test', 'course.v3.wechat.test');

  router.get('third', '/comments', miniAuth, 'course.v3.institution.getComments');// 评论列表
  router.get('third', '/search/hot', miniAuth, 'course.v3.institution.getHotSearch');// 热搜
  router.get('third', '/search/suggest', miniAuth, 'course.v3.institution.getSuggestSearch');// 搜索联想
  router.get('third', '/search', miniAuth, 'course.v3.institution.search');// 搜索
  router.get('third', '/user/search', miniAuth, 'course.v3.institution.getUserSearch');// 用户搜索历史
  router.delete('third', '/user/search', miniAuth, 'course.v3.institution.deleteUserSearch');// 清空用户搜索记录

  router.get('third', '/article/all', miniAuth, 'course.v3.institution.getArticlesByCat');// 根据分类获取选课指南
  router.get('third', '/article/:id', miniAuth, 'course.v3.institution.getArticle');// 获取选课指南详情

  router.post('third', '/like', miniAuth, 'course.v3.institution.like');// 点赞
  router.post('third', '/unlike', miniAuth, 'course.v3.institution.unlike');// 取消点赞

};
