'use strict';

const Controller = require('egg').Controller;

class Export20190425 extends Controller {
    /**
     * 关注
     */
    async exportHouseImages() {
        const { ctx } = this;
        const house_images = await ctx.realestateModel.HouseImage.findAll();
        let count = 0;
        for (let i in house_images) {
            const item = house_images[i];
            const add_data = {
                path: 'https://r.51gjj.com/' + item.path,
                type: item.type,
                connectId: item.connect_id,
                remark: item.remark,
                state: 1,
                description: '',
            };
            const result = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/houseimage', add_data, { method: 'POST' });
            if (result.status === 201) count++;
        }
        ctx.success(count);

    }

    async exportResidential() {

        const { ctx } = this;
        const residentials = await ctx.realestateModel.Residential.findAll();
        let count = 0;
        let result;
        for (let i in residentials) {
            const residential = residentials[i];
            const add_data = {
                name: residential.name,
                province: residential.province,
                city: residential.city,
                county: residential.county,
                region: residential.region,
                propertyRightYears: residential.property_right_years,
                propertyFee: residential.property_fee,
                propertyCompany: residential.property_company,
                heatSupplyType: residential.heat_supply_type,
                waterSupplyType: residential.water_suppler_type,
                powerSupplyType: residential.power_suppler_type,
                landArea: residential.land_area,
                houseArea: residential.house_area,
                areaRatio: residential.area_ratio,
                greenRatio: residential.green_ratio,
                archType: residential.arch_type,
                nearBy: residential.nearby,
                state: 1,
                remark: '',
            }
            result = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/residential', add_data, { method: 'POST' });
            if (result.status === 201) {
                count++;
            }
            // if(count === 1) break;
        }
        ctx.success(count);;
    }

    //新房
    async moveNewHouse() {
        const { ctx } = this;
        let filter = {
            order: [['id', 'ASC']]
        };
        let mysqlData = await ctx.realestateModel.NewHouse.findAll(filter);
        let ret = [];
        let reterr = [];
        if (mysqlData.length > 0) {
            for (let i in mysqlData) {
                let data = {
                    name: mysqlData[i].name,
                    residentialId: mysqlData[i].residential_id,
                    address: mysqlData[i].address,
                    saleAddress: mysqlData[i].sale_address,
                    tags: mysqlData[i].tags,
                    saleType: mysqlData[i].sale_type,
                    houseType: mysqlData[i].house_type,
                    referenceAvgPrice: mysqlData[i].reference_avg_price || 0,
                    referenceTotalPrice: mysqlData[i].reference_total_price || 0,
                    image: 'https://r.51gjj.com/' + mysqlData[i].image,
                    discount: mysqlData[i].discount || 0,
                    favourableInfo: mysqlData[i].favourable_info || '',
                    decorationType: mysqlData[i].decoration_type || 0,
                    description: mysqlData[i].description || '',
                    openDate: mysqlData[i].open_date,
                    dueDate: (mysqlData[i].due_date === undefined || mysqlData[i].due_date === "0000-00-00 00:00:00" || mysqlData[i].due_date === 'Invalid date') ? null : mysqlData[i].due_date,
                    landArea: mysqlData[i].land_area,
                    houseArea: mysqlData[i].house_area,
                    areaRatio: mysqlData[i].area_ratio,
                    greenRatio: mysqlData[i].green_ratio,
                    planRooms: mysqlData[i].plan_rooms,
                    planParks: mysqlData[i].plan_parks,
                    planNearBy: mysqlData[i].plan_near_by,
                    preSalePermit: mysqlData[i].pre_sale_permit,
                    preSalePermitDate: (mysqlData[i].pre_sale_permit_date === '暂无信息' || mysqlData[i].pre_sale_permit_date === '-') ? null : mysqlData[i].pre_sale_permit_date,
                    buildingNumbers: mysqlData[i].building_numbers,
                    cornerMarker: mysqlData[i].corner,
                    orderNum: mysqlData[i].order_num,
                    state: mysqlData[i].state,
                    remark: mysqlData[i].remark || '',
                }
                ctx.logger.info(JSON.stringify(data));
                let temp = await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/newhouse/', data, { method: 'POST' });
                if (temp.status === 201) {
                    ret.push(temp);
                } else {
                    reterr.push(mysqlData[i]);
                }
            }
        }
        ctx.success({ retL: ret.length, fl: mysqlData.length, error: reterr });
    }


    //新房类型
    async moveNewHouseType() {
        const { ctx } = this;
        let filter = {
            order: [['id', 'ASC']]
        };
        let mysqlData = await ctx.realestateModel.NewHouseType.findAll(filter);
        let ret = [];
        if (mysqlData.length > 0) {
            for (let i in mysqlData) {
                let data = {
                    newHouseId: mysqlData[i].new_house_id,
                    type: mysqlData[i].type,
                    image: 'https://r.51gjj.com/' + mysqlData[i].image,
                    tags: mysqlData[i].tags,
                    apartment: mysqlData[i].apartment,
                    saleType: mysqlData[i].sale_type,
                    area: mysqlData[i].area,
                    orientation: mysqlData[i].orientation || '',
                    num: mysqlData[i].num,
                    price: mysqlData[i].price,
                    discount: mysqlData[i].discount,
                    state: mysqlData[i].state,
                    remark: mysqlData[i].remark || '',
                }
                ctx.logger.info(JSON.stringify(data));
                let temp = await await ctx.helper.send_request(this.config.HOUSE_SERVICE_API + '/v1/newhousetype/', data, { method: 'POST' });
                ret.push(temp);
            }
        }
        ctx.success(ret.length);
    }

}

module.exports = Export20190425;
