'use strict';
module.exports = app => {
    const { INTEGER, TEXT } = app.Sequelize;

    const HousePriceIncrease = app.blockModel.define('house_price_increase', {
        id: {
            type: INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true,
        },
        increase_json: {
            type: TEXT,
            allowNull: true,
            field: 'increase_json',
            get() {
                const increase_json = this.getDataValue('increase_json');
                if (increase_json) {
                    try {
                        return JSON.parse(increase_json);
                    } catch (error) {
                        return [];
                    }
                }
                return [];
            },
        },
    }, {
            timestamps: false,
            tableName: 'house_price_increase',
            freezeTableName: true,
        });

    HousePriceIncrease.one = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await HousePriceIncrease.findOne({
            attributes: attributes,
            where: where,
        });
    }


    HousePriceIncrease.all = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await HousePriceIncrease.findAll({
            attributes: attributes,
            where: where,
        });
    }

    HousePriceIncrease.list = async (data = {}) => {
        const limit = data.limit ? data.limit : 10;
        const page = data.page ? data.page : 1;
        const order = data.order ? data.order : [];
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const condition = {
            offset: (page - 1) * limit,
            limit,
            where: where,
            order: order,
            attributes: attributes,
        };

        const { count, rows } = await HousePriceIncrease.findAndCountAll(condition);
        return { page, count, rows };
    }

    HousePriceIncrease.add = async (data) => {
        try {
            //返回promise对象实力 instance 
            const res = await HousePriceIncrease.create(data);
            //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
            return res.id;
        } catch (error) {
            ctx.status = 500;
            throw (error);
        }
    }

    HousePriceIncrease.edit = async (data) => {
        const where = data.where;
        const params = data.params;
        HousePriceIncrease.update(params, {
            where: where
        }).catch(e => res.json({ status: 500, error: e }));
    }

    return HousePriceIncrease;

};
