'use strict';
const Service = require('egg').Service;

class CommonService extends Service {
  // 获取51shequ的oss签名
  async get_business_signature() {
    const { ctx } = this;

    const region='oss-cn-hangzhou';
    const bucket='51shequ';

    const id= 'LTAIbdayv82O7OYM';
    const key= 'plCSzfiZCpMoh39omrzdaHHEltv4Un';
    const host = '//' + bucket + '.' + region + '.aliyuncs.com';
    const url="//r.51gjj.com/";
    let now = Math.round(new Date().getTime()/1000).toString();
    const expire = 120;
    let end = now + expire;

    let expiration = new Date().toISOString().replace(/\..+/,'') + 'Z';

    let dir = 'webpublic/resume/';

    //最大文件大小.用户可以自己设置
    let condition = new Array(3);
    condition[0] = 'content-length-range';
    condition[1] = 0;
    condition[2] = 1048576000;

    let start = new Array('starts-with', '$key', dir);

    let conditions = new Array(condition, start);   

   
    let policy = {expiration: expiration, conditions: conditions};
    

    let base64_policy = new Buffer(JSON.stringify(policy)).toString('base64');
 
    let string_to_sign = base64_policy;
    const crypto = require('crypto');
    let signature = crypto.createHash('sha1').update(string_to_sign).digest().toString('base64');;
    let config = {
      region,
      accessKeyId: id,
      accessKeySecret: key,
      bucket: bucket,

    }
    let response = {
      accessid: id,
      static_host: url + dir,
      host: host,
      policy: base64_policy,
      signature: signature,
      expire: end,
      config: config,
      dir
    };

    return response;

  }


}

module.exports = CommonService;
