'use strict';

module.exports = app => {
    const router = app.router.namespace(app.config.projectRootPath + '/cd');
    const loginAuth = app.middleware.loginAuth({ type: 'new' });//登录中间件

    //贷款计算器
    router.post('/caculator', 'cd.loanCaculator.caculator');

    //资讯-详细内容
    router.get('/news/:id', 'cd.news.getNews');
    //资讯-列表
    router.post('/news/list', 'cd.news.getNewsList');

    //预售楼盘-搜索历史
    router.get('/presell/search_history', loginAuth, 'cd.presellSearchHistory.getSearchHistory');
    //预售楼盘-清除搜索历史
    router.put('/presell/search_history', loginAuth, 'cd.presellSearchHistory.cleanSearchHistory');
    //预售楼盘-列表
    router.post('/presell/house/list', 'cd.presellHouse.getPresellHouseList');
    //预售楼盘-详情
    router.get('/presell/house/:id', 'cd.presellHouse.getPresellHouse');

    //摇号-楼盘名字模糊匹配
    router.post('/lottery/name', loginAuth, 'cd.lotteryPublicise.getHouseName');
    //摇号-用户查询
    router.post('/lottery/publicise', loginAuth, 'cd.lotteryPublicise.getLotteryPublicise');
    //摇号-用户查询历史
    router.get('/lottery/query/list', loginAuth, 'cd.lotteryPublicise.getUserQueryList');
    //摇号-用户根据查询历史重新查询
    router.post('/lottery/review', loginAuth, 'cd.lotteryPublicise.updateQuery');




};