'use strict';

module.exports = app => {
    const router = app.router.namespace(app.config.projectRootPath + '/course');
    const loginAuth = app.middleware.loginAuth({ type: 'new' });//登录中间件
    const miniAuth = app.middleware.miniAuth();//登录中间件

    router.get('/options', 'course.option.getOptions');//筛选项
    router.post('/institutions', 'course.institution.institutionList');//机构列表
    router.get('/institutions', 'course.institution.institutionList');//机构列表
    router.get('/institution/:institution_id/:area_id', 'course.institution.institutionInfo');//机构详情
    router.post('/classes', 'course.institution.classList');//课程列表
    router.get('/classes', 'course.institution.classList');//课程列表
    router.get('/class/:class_id', 'course.institution.classInfo');//课程详情
    router.post('/teachers', 'course.institution.teacherList');//老师列表
    router.get('/teachers', 'course.institution.teacherList');//老师详情
    router.get('/teacher/:teacher_id', 'course.institution.teacherInfo');//老师详情

    router.post('/user/auth', 'course.user.auth');//微信授权登录
    router.post('/user/register_user', miniAuth, 'course.user.registerUserInfo');//授权后注册用户

    router.get('/user/baby', 'course.user.getBabyInfo');//获取baby信息
    router.post('/user/baby', 'course.user.saveBabyInfo');//保存baby信息
    router.delete('/user/baby', 'course.user.delBabyInfo');//删除baby信息

    router.get('/user/collection/institution', 'course.user.getCollectInstitutions');//收藏的机构列表
    router.post('/user/collection/institution', 'course.user.collectInstitution');//收藏机构

};
