'use strict';

const Service = require('egg').Service;

class LbsService extends Service {
  // 计算两个经纬度之间的距离，用Haversine公式，单位:m
  async getDistance(from, to) {
    const rad_from = from.lat * Math.PI / 180.0;
    const rad_to = to.lat * Math.PI / 180.0;
    const sub_lat = rad_from - rad_to;
    const sub_lng = from.lng * Math.PI / 180.0 - to.lng * Math.PI / 180.0;
    const r = 6378137; // 地球半径
    const distance = r * 2 * Math.asin(Math.sqrt(Math.pow(Math.sin(sub_lat / 2), 2) + Math.cos(rad_from) * Math.cos(rad_to) * Math.pow(Math.sin(sub_lng / 2), 2)));
    return distance;
  }

  // 腾讯位置服务WebService API,距离计算（一对多）
  // 返回示例：
  // {
  //   "results": [
  //           {
  //               "from": {
  //                   "lat": 39.983171,
  //                   "lng": 116.308479
  //               },
  //               "to": {
  //                   "lat": 39.996059,
  //                   "lng": 116.353454
  //               },
  //               "distance": 5354.7,
  //               "duration": 1678
  //           },
  //           {
  //               "from": {
  //                   "lat": 39.983171,
  //                   "lng": 116.308479
  //               },
  //               "to": {
  //                   "lat": 39.949226,
  //                   "lng": 116.394309
  //               },
  //               "distance": 10495.8, // 起点到终点的距离，单位：米。如果radius半径过小或者无法搜索到，则返回-1
  //               "duration": 2635 // 表示从起点到终点的结合路况的时间，秒为单位。 注：步行方式不计算耗时，该值始终为0
  //           }
  //       ]
  // }
  async getLBSDistance(mode = 'driving', from, toArr) {
    const { ctx } = this;
    const to = [];
    let result = [];
    for (const v of toArr) {
      to.push(String(v.lat) + ',' + String(v.lng));
    }
    console.info(from);
    const params = {
      mode, // driving, walking；默认driving
      from: String(from.lat) + ',' + String(from.lng),
      to: to.join(';'),
      key: ctx.app.config.TX_LBS_KEY,
    };

    const resp = await ctx.helper.send_request(ctx.app.config.TX_LBS_DISTANCE_URL, params, { method: 'GET' });
    // resp.data.status 状态码，0：正常，310：请求参数信息有误，311：Key格式错误，306：请求有护持信息请检查字符串，110：请求来源未被授权
    ctx.logger.info('tx_lbs_distance_params: ' + JSON.stringify(params));
    ctx.logger.info('tx_lbs_distance_resp: ' + JSON.stringify(resp));
    if (resp.status === 200) {
      // 判断响应是否正确
      if (resp.data.status === 0) {
        result = resp.data.result.elements;
      }
    }

    return { results: result };
  }

  // 地址解析
  async getLBSAddress(address) {
    const { ctx } = this;
    let result = {};
    const params = {
      address,
      key: ctx.app.config.TX_LBS_KEY,
    };

    const resp = await ctx.helper.send_request(ctx.app.config.TX_LBS_ADDRESS_URL, params, { method: 'GET' });
    // resp.data.status 状态码，0：正常，310：请求参数信息有误，311：Key格式错误，306：请求有护持信息请检查字符串，110：请求来源未被授权
    ctx.logger.info('tx_lbs_address_resp: ' + JSON.stringify(resp));
    if (resp.status === 200) {
      // 判断响应是否正确
      if (resp.data.status === 0) {
        result = resp.data.result;
      }
    }

    return { result };
  }

  // 逆地址解析
  async getLBSLocation(location) {
    const { ctx } = this;
    let result = {};
    const params = {
      location: location.lat + ',' + location.lng,
      key: ctx.app.config.TX_LBS_KEY,
    };

    const resp = await ctx.helper.send_request(ctx.app.config.TX_LBS_ADDRESS_URL, params, { method: 'GET' });
    // resp.data.status 状态码，0：正常，310：请求参数信息有误，311：Key格式错误，306：请求有护持信息请检查字符串，110：请求来源未被授权
    ctx.logger.info('tx_lbs_address_resp: ' + JSON.stringify(resp));
    if (resp.status === 200) {
      // 判断响应是否正确
      if (resp.data.status === 0) {
        result = resp.data.result;
      }
    }

    return { result };
  }

  // 地址解析
  async getLBSAddress(address) {
    const { ctx } = this;
    let result = {};
    const params = {
      address,
      key: ctx.app.config.TX_LBS_KEY,
    };

    const resp = await ctx.helper.send_request(ctx.app.config.TX_LBS_ADDRESS_URL, params, { method: 'GET' });
    // resp.data.status 状态码，0：正常，310：请求参数信息有误，311：Key格式错误，306：请求有护持信息请检查字符串，110：请求来源未被授权
    ctx.logger.info('tx_lbs_location_resp: ' + JSON.stringify(resp));
    if (resp.status === 200) {
      // 判断响应是否正确
      if (resp.data.status === 0) {
        result = resp.data.result;
      }
    }

    return { result };
  }

  // 逆地址解析
  async getLBSIp() {
    const { ctx } = this;
    let result = {};
    const ip = ctx.helper.getClientIP();
    if (!ip) {
      return result;
    }
    const params = {
      ip: ip,
      key: ctx.app.config.TX_LBS_KEY,
    };

    const resp = await ctx.helper.send_request(ctx.app.config.TX_LBS_ADDRESS_URL + '/ip', params, { method: 'GET' });
    // resp.data.status 状态码，0：正常，310：请求参数信息有误，311：Key格式错误，306：请求有护持信息请检查字符串，110：请求来源未被授权
    ctx.logger.info('tx_lbs_ip_resp: ' + JSON.stringify(resp));
    if (resp.status === 200) {
      // 判断响应是否正确
      if (resp.data.status === 0) {
        result = resp.data.result;
      }
    }

    return { result };
  }



}

module.exports = LbsService;
