
'use strict';

const Service = require('egg').Service;
const moment = require('moment');
const _ = require('lodash');

class CommonService extends Service {

    /**
     * 
     * @param {*} type 黑名单00通话01
     * @param {*} id 报告自增编号(report_id)
     */
    async getReportNo(type, id) {
        let prefix = '51GJJ' + moment().format('YYYYMMDD') + type;
        let suffix = String(Number(id) + 12580);
        if (suffix.length > 5) {
            let subStart = suffix.length - 5;
            suffix = suffix.substring(subStart, suffix.length + 1);
        }
        return prefix + suffix;
    }


    /**
    * 
    * @param {*} type 黑名单00通话01
    * @param {*} id 订单自增编号(order_id)
    */
    async getOrdertNo(type, id) {
        let prefix = '51GJJOD' + moment().format('YYYYMMDD') + type;
        let suffix = String(Number(id) + 12580);
        if (suffix.length > 5) {
            let subStart = suffix.length - 5;
            suffix = suffix.substring(subStart, suffix.length + 1);
        }
        return prefix + suffix;
    }

    /**
     * 签名函数
     * @param {*} params 需要签名的参数
     */
    async sign(params, appSecret) {
        const { ctx } = this;
        let sign = '';
        if (!params) {
            return sign;
        }
        //键名排序
        const sortParamsKey = Object.keys(params).sort();
        //键值拼接-升序
        let sortValues = '';
        for (let i in sortParamsKey) {
            if (sortParamsKey[i] === 'sign') {
                continue;
            }
            sortValues += sortParamsKey[i] + '=' + params[sortParamsKey[i]] + '&';
        }
        sortValues += 'appSecret=' + appSecret;
        sign = await ctx.helper.md5(sortValues).toUpperCase();
        ctx.logger.info({ sign: sign });
        return sign;
    }

}

module.exports = CommonService;
