'use strict';

module.exports = (options, app) => {

    return async function (ctx, next) {

        const session_id = ctx.headers.Session_Id;
        const key = 'course_user_session_' + session_id;
        const auth_info = await app.memcache.get(key);
        const openid = auth_info.openid;
        const user_uuid = auth_info.user_uuid;
        const token = ctx.headers.token;
        if (ctx.helper.md5(openid + user_uuid + 'jbwl') != token) {
            ctx.failed('login auth error');
        }
        ctx.setUserUuid(user_uuid);

        await next();
    };
};
