'use strict';

const Controller = require('egg').Controller;

class OptionsController extends Controller {

    async getOptions() {
        const { ctx } = this;
        const input_parmas = ctx.params;
        const rule = {
            city_code: { type: 'string', required: true }
        }
        ctx.validate(rule, input_parmas);
        const city_code = input_parmas.city_code;
        const ret = await ctx.service.house.option.getOptions(city_code);
        ctx.success(ret);
    }
}

module.exports = OptionsController;
