'use strict';

const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE, ENUM} = app.Sequelize;
  const OfficialJob = app.blockModel.define('zhiren_job', {
    id: { type: STRING, primaryKey: true, autoIncrement: true },
    job_type: INTEGER,
    job_type_id: INTEGER,
    name: STRING,
    duty: STRING,
    demand: STRING,
    salary: STRING,
    exprence: STRING,
    grade: STRING,
    status: INTEGER,
    is_deleted: INTEGER,
    created_time: {
      type: DATE,
      get() {
        const date = this.getDataValue('created_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    updated_time: {
      type: DATE,
      get() {
        const date = this.getDataValue('updated_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'zhiren_job',
  });

  OfficialJob.one = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
      return await OfficialJob.findOne({
          attributes: attributes,
          where : where,
      });
  }


  OfficialJob.all = async (data) => {
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    return await OfficialJob.findAll({
        attributes: attributes,
        where : where,
    });
  }

  OfficialJob.list = async (data = {}) => {
    const limit = data.limit ? data.limit : 10;
    const page = data.page ? data.page : 1;
    const order = data.order ? data.order : [];
    const attributes = data.attributes ? data.attributes : {};
    const where = data.where ? data.where : {};
    const condition = {
      offset: (page - 1) * limit,
      limit,
      where: where,
      order: order,
      attributes: attributes,
    };
    console.log(condition);
    const { count, rows } =  await OfficialJob.findAndCountAll(condition);
    return { page, count, rows };
  }

  OfficialJob.add = async (data) => {
    try {
      //返回promise对象实力 instance 
      const res = await OfficialJob.create(data);
      //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
      return res.id;  
    } catch(error) {
      ctx.status = 500;
      throw (error);
    }    
  }

  OfficialJob.edit = async (data) => {
    const where = data.where;
    const params = data.params;
    OfficialJob.update(params, {
      where: where
    }).catch( e => res.json({status: 500, error: e}));
  }

  return OfficialJob;

};
