
'use strict';

const Service = require('egg').Service;
const moment = require('moment');
const _ = require('lodash');

class PresellHouseService extends Service {

    /**
     * 预售楼盘列表
     * @param {*} condition 
     */
    async getList(condition) {
        const { ctx } = this;
        let page = Number(condition.page) || 1;
        let limit = Number(condition.limit) || 20;
        let offset = (page - 1) * limit;
        let filter = {
            page,
            limit,
            offset,
            attributes: ['id', 'name', 'market_time', 'purpose'],
            where: {
                valid: 1,
                status: 'online',
            },
            order: [['market_time', 'desc']]
        }
        let list = await ctx.realestateModel.CdNews.findAndCountAll(filter);
        let ret = {
            list: list.row,
            page: list.count,
            page_size: Math.ceil(list.count / limit)
        }
        return ret;
    }

    /**
     * 根据编号获取预售楼盘信息
     * @param {integer} id 资讯id
     */
    async getPresellHouse(id) {
        const { ctx } = this;
        let filter = {
            attributes: ['id', 'name', 'phone', 'presell_permit', 'purpose', 'presell_area', 'market_time'],
            where: {
                id: id,
                valid: 1,
                status: 'online',
            }
        }
        let ret = await ctx.realestateModel.CdPresellHouse.findOne(filter);
        return ret;
    }



}

module.exports = PresellHouseService;
