'use strict';
module.exports = app => {
    const { INTEGER, TEXT } = app.Sequelize;

    const HouseSupplyDemand2 = app.blockModel.define('house_supply_demand2', {
        id: {
            type: INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true,
        },
        pid: INTEGER,
        supply_demand_json: {
            type: TEXT,
            allowNull: true,
            field: 'supply_demand_json',
            get() {
                const supply_demand_json = this.getDataValue('supply_demand_json');
                if (supply_demand_json) {
                    try {
                        return JSON.parse(supply_demand_json);
                    } catch (error) {
                        return [];
                    }
                }
                return [];
            },
        },
    }, {
            timestamps: false,
            tableName: 'house_supply_demand2',
            freezeTableName: true,
        });

    HouseSupplyDemand2.one = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await HouseSupplyDemand2.findOne({
            attributes: attributes,
            where: where,
        });
    }


    HouseSupplyDemand2.all = async (data) => {
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        return await HouseSupplyDemand2.findAll({
            attributes: attributes,
            where: where,
        });
    }

    HouseSupplyDemand2.list = async (data = {}) => {
        const limit = data.limit ? data.limit : 10;
        const page = data.page ? data.page : 1;
        const order = data.order ? data.order : [];
        const attributes = data.attributes ? data.attributes : {};
        const where = data.where ? data.where : {};
        const condition = {
            offset: (page - 1) * limit,
            limit,
            where: where,
            order: order,
            attributes: attributes,
        };

        const { count, rows } = await HouseSupplyDemand2.findAndCountAll(condition);
        return { page, count, rows };
    }

    HouseSupplyDemand2.add = async (data) => {
        try {
            //返回promise对象实力 instance 
            const res = await HouseSupplyDemand2.create(data);
            //从promise 实例中中获得需要的id号，id 必须是自增长，而且必须主键，否则返回null
            return res.id;
        } catch (error) {
            ctx.status = 500;
            throw (error);
        }
    }

    HouseSupplyDemand2.edit = async (data) => {
        const where = data.where;
        const params = data.params;
        HouseSupplyDemand2.update(params, {
            where: where
        }).catch(e => res.json({ status: 500, error: e }));
    }

    return HouseSupplyDemand2;

};
