'use strict';


const moment = require('moment');

module.exports = app => {
  const { STRING, INTEGER, DATE, DECIMAL, TEXT, ENUM } = app.Sequelize;

  const CourseStudentVideo = app.classModel.define('course_student_video', {
    id: {
      type: INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    institution_id: INTEGER,
    video_url: STRING,
    title: STRING,
    content: STRING,
    age: STRING,
    time: STRING,
    sort: INTEGER,
    cover_image: STRING,
    status: ENUM('offline', 'online'),
    is_deleted: INTEGER,
    created_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('created_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    updated_time: {
      type: DATE,
      allowNull: true,
      get() {
        const date = this.getDataValue('updated_time');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
  }, {
    timestamps: false,
    tableName: 'course_student_video',
  });

  return CourseStudentVideo;

};
