
'use strict';

const Service = require('egg').Service;
const moment = require('moment');
const _ = require('lodash');
const RiskConfig = {
    low: {
        standard: '低',
        msg: '您的风险指数较低，有利于机构对您的申贷评估，请继续保持良好的信用行为。',
    },
    medium: {
        standard: '中',
        msg: '您的风险指数中等，请合理申贷，保持良好还款习惯，避免申贷过多影响个人信用。',
    },
    high: {
        standard: '高',
        msg: '您的风险指数较高， 再次申贷容易被拒，建议3个月内不再申请贷款，并养成良好的还款习惯。',
    },
}
const DtldConfig = {
    empty: '您最近6个月没有贷款记录，说明您是在自己的偿还范围内理性借贷，请继续保持。',
    less: '您最近很少进行贷款申请，说明您比较合理地利用和分配资金，有利于提高您的个人信用。',
    more: '您最近6个月网贷申请次数与平台较多，存在多头共债风险，被拒概率极高。建议您在6个月内申请贷款控制在7次以内。',
}

const IdCardConfig = {
    empty: '您的身份证和手机号暂无关联风险，请继续保持良好的信用行为，保护好您的身份信息，不要轻易将身份证借用给他人。',
    have: '您的XX关联了多个NN，请联系平台更改，并同时保护好您的身份信息，不要轻易将身份证借用给他人。'
}

const DeviceConfig = {
    high: '您的设备关联的XX类APP数量较多，建议合理使用APP，并删除不常使用的APP，以免影响申贷通过率。',
    low: '您的设备有关联XX类APP，建议删除此类APP，以免影响申贷通过率。',
    empty: '您的设备关联APP表现很健康，请继续保持。',
}

class BlacklistService extends Service {

    /**
     * 黑名单报告
     */
    async getReport() {
        const { ctx } = this;
        let ret = {
            basic: {
                risk_index: '10%',
                risk_standard: '低',
                msg: '',
                name: '李鑫',
                report_no: '9527',
                phone: '183****5747',
                age: '21',
                id_card: '5101**********4311',
                city: '浙江-杭州',
                expire_time: '2019-010-30',
            },
            blacklist: {
                blacklist_of_internet_loans: 1,//是否命中网贷黑名单
                blacklist_of_court_dishonesty: 1,//是否命中法院失信名单
                blacklist_of_industry: 1,//是否命中行业黑名单
                blacklist_of_ds_industry: 1,//是否命中电商行业黑名单
                blacklist_of_bx_industry: 1,//是否命中保险行业黑名单
                blacklist_of_zc_industry: 1,//是否命中租车行业黑名单
                blacklist_of_zf_industry: 1,//是否命中三方支付行业黑名单
                blacklist_of_jd_industry: 1,//是否命中酒店行业黑名单             
            },
            dtld: {
                reg_count_1month: 8,//近1月注册笔数
                reg_count_3month: 8,//近3月注册笔数
                reg_count_6month: 8,//近6月注册笔数
                consume_reg_count_1month: 8,//近1月消金机构注册笔数
                consume_reg_count_3month: 8,//近3月消金机构注册笔数
                consume_reg_count_6month: 8,//近6月消金机构注册笔数
                loan_reg_count_1month: 8,//近1月网贷机构注册笔数
                loan_reg_count_3month: 8,//近3月网贷机构注册笔数
                loan_reg_count_6month: 8,//近6月网贷机构注册笔数
                consume_reg_platform_count_1month: 8,//近1月注册消金机构数
                consume_reg_platform_count_3month: 8,//近3月注册消金机构数
                consume_reg_platform_count_6month: 8,//近6月注册消金机构数
                loan_reg_platform_count_1month: 8,//近1月注册网贷机构数
                loan_reg_platform_count_3month: 8,//近3月注册网贷机构数
                loan_reg_platform_count_6month: 8,//近6月注册网贷机构数
                reg_platform_count_1month: 8,//近1月注册机构数
                reg_platform_count_3month: 8,//近3月注册机构数
                reg_platform_count_6month: 8,//近6月注册机构数
                credit_count_1month: 8,//近1月放款笔数
                credit_count_3month: 8,//近3月放款笔数
                credit_count_6month: 8,//近6月放款笔数
                credit_amount_1month: '(2000-30000]',//近1月放款金额
                credit_amount_3month: '(2000-30000]',//近3月放款金额
                credit_amount_6month: '(2000-30000]',//近6月放款金额
                credit_closed_count_1month: 8,//近1月已结清放款笔数
                credit_closed_count_3month: 8,//近3月已结清放款笔数
                credit_closed_count_6month: 8,//近6月已结清放款笔数
                credit_closed_amount_1month: '(2000-30000]',//近1月已结清放款金额
                credit_closed_amount_3month: '(2000-30000]',//近3月已结清放款金额
                credit_closed_amount_6month: '(2000-30000]',//近6月已结清放款金额
                consume_credit_count_1month: 8,//近1月消金机构放款笔数
                consume_credit_count_3month: 8,//近3月消金机构放款笔数
                consume_credit_count_6month: 8,//近6月消金机构放款笔数
                loan_credit_count_1month: 8,//近1月网贷机构放款笔数
                loan_credit_count_3month: 8,//近3月网贷机构放款笔数
                loan_credit_count_6month: 8,//近6月网贷机构放款笔数
                consume_credit_platform_count_1month: 8,//近1月放款消金机构数
                consume_credit_platform_count_3month: 8,//近3月放款消金机构数
                consume_credit_platform_count_6month: 8,//近6月放款消金机构数
                loan_credit_platform_count_1month: 8,//近1月放款网贷机构数
                loan_credit_platform_count_3month: 8,//近3月放款网贷机构数
                loan_credit_platform_count_6month: 8,//近6月放款网贷机构数
                credit_platform_count_1month: 8,//近1月放款机构数
                credit_platform_count_3month: 8,//近3月放款机构数
                credit_platform_count_6month: 8,//近6月放款机构数
                msg: '',
            },
            overdue: {//逾期详情
                list: [
                    {
                        overdue_date: '2019-07',//逾期时间    
                        overdue_amount: 5000,//逾期金额    
                        overdue_time: '30-60天',//逾期时长    
                        is_settle: '是',//是否已经结清
                    },
                    {
                        overdue_date: '2019-07',//逾期时间    
                        overdue_amount: 5000,//逾期金额    
                        overdue_time: '30-60天',//逾期时长    
                        is_settle: '是',//是否已经结清
                    },
                ],
                msg: '',
            },
            six_months: {//近6个月关联风险
                id_card_relevant: {//身份关联风险
                    id_card_relevant_mobilephone_count: 1,//身份证关联手机号个数
                    id_card_relevant_device_count: 3,//身份证关联设备号个数
                    mobilephone_relevant_id_card_count: 1,//手机号关联身份证个数
                    msg: '',
                },
                mobilephone_relecvant: {//设备关联风险
                    relevant_loan_app_count_6month: 3,//近6月关联的信贷app个数  
                    relevant_gamble_app_count_6month: 2,//近6月关联的赌博app个数  
                    relevant_ip_app_count_6month: 2,//近6月关联的代理ip或篡改gps的app个数 
                    relevant_other_app_count_6month: 1,//近6月关联的其他app个数                     
                    msg: '',
                }
            }
        };

        //风险分值计算
        let blacklistScore = (ret.blacklist.blacklist_of_internet_loans === 1 || ret.blacklist.blacklist_of_court_dishonesty === 1) ? 40 : (ret.blacklist.blacklist_of_industry === 1 ? 30 : 0);
        let dtScore = await this.getDtScore(ret.dtld.reg_count_6month, ret.dtld.credit_count_6month);
        let idScore = await this.getIdCardScore(ret.six_months.id_card_relevant.id_card_relevant_mobilephone_count, ret.six_months.id_card_relevant.mobilephone_relevant_id_card_count);
        let appScore = (ret.six_months.mobilephone_relecvant.relevant_ip_app_count_6month > 1 || ret.six_months.mobilephone_relecvant.relevant_gamble_app_count_6month > 1) ? 10 : 0;
        ret.basic.risk_index = blacklistScore + dtScore + idScore + appScore;
        //风险标准计算
        let riskLevel = 'low';
        if (ret.blacklist_of_internet_loans === 1 || ret.blacklist_of_court_dishonesty === 1 || ret.basic.risk_index >= 50 || dtScore === 30) {
            riskLevel = 'high';
        } else if (ret.basic.risk_index >= 20 && ret.basic.risk_index < 50) {
            riskLevel = 'medium';
        } else {
            riskLevel = 'low';
        }
        ret.basic.risk_index += '%';
        ret.basic.risk_standard = RiskConfig[riskLevel].standard;
        ret.basic.msg = RiskConfig[riskLevel].msg;

        //多头雷达msg
        let dtldLevel = 'empty';
        let n = 7;
        if (ret.dtld.reg_platform_count_6month === 0) {
            dtldLevel = 'empty';
        } else if (ret.dtld.reg_platform_count_6month < n) {
            dtldLevel = 'less';
        } else {
            dtldLevel = 'more';
        }
        ret.dtld.msg = DtldConfig[dtldLevel];

        //逾期msg
        ret.overdue.msg = '逾期次数过多，逾期天数较长，逾期金额较大等，会被认为你的还款能力弱，贷款申请被拒概率较大。如显示无记录，则未查得逾期记录，或贷款平台没有及时上传你的逾期信息。实际逾期情况，请以个人借贷情况为准。';

        //近六个月msg
        //身份关联
        let idCardLevel = 'empty';
        let idCardNeedSort = [
            {
                n: ret.six_months.id_card_relevant.id_card_relevant_mobilephone_count,
                first: '身份证',
                second: '手机号',
            },
            {
                n: ret.six_months.id_card_relevant.mobilephone_relevant_id_card_count,
                first: '手机号',
                second: '身份证',
            },
            {
                n: ret.six_months.id_card_relevant.id_card_relevant_device_count,
                first: '身份证',
                second: '设备号',
            },
        ];
        let idCardMax = _.orderBy(idCardNeedSort, ['n'], ['desc'])[0];
        if (idCardMax.n >= 2) {
            idCardLevel = 'have';
        } else {
            idCardLevel = 'empty';
        }
        ret.six_months.id_card_relevant.msg = IdCardConfig[idCardLevel].replace(/XX/, idCardMax.first).replace(/NN/, idCardMax.second);

        //设备关联
        let deviceLevel = 'empty';
        let deviceNeedSort = [
            {
                n: ret.six_months.mobilephone_relecvant.relevant_ip_app_count_6month,
                type: '代理ip/篡改GPS类',
            },
            {
                n: ret.six_months.mobilephone_relecvant.relevant_gamble_app_count_6month,
                type: '赌博类'
            },
            {
                n: ret.six_months.mobilephone_relecvant.relevant_loan_app_count_6month,
                type: '信贷类'
            },
        ];
        let deviceMax = _.orderBy(deviceNeedSort, ['n'], ['desc'])[0];
        if (deviceMax.n >= 2) {
            deviceLevel = 'high';
        } else if (deviceMax.n === 1) {
            deviceLevel = 'low';
        } else {
            deviceLevel = 'empty';
        }
        ret.six_months.mobilephone_relecvant.msg = DeviceConfig[deviceLevel].replace(/XX/, deviceMax.type);

        ret.basic.report_no = await ctx.service.credit.common.getReportNo('00', 12344);


        return ret;
    }

    /**
     * 获取多头借贷的分值
     * @param {*} a 近6月消金机构注册笔数
     * @param {*} b 近6月放款笔数
     */
    async getDtScore(a, b) {
        let aScore = 0;
        let bScore = 0;
        if (a > 30) {
            aScore = 30;
        } else if (a > 15) {
            aScore = 20;
        } else if (a > 5) {
            aScore = 10;
        } else {
            aScore = 0;
        }
        if (b > 30) {
            bScore = 30;
        } else if (b > 7) {
            bScore = 20;
        } else if (b > 3) {
            bScore = 10;
        } else {
            bScore = 0;
        }
        let score = aScore >= bScore ? aScore : bScore;
        return score;
    }

    /**
     * 
     * @param {*} a 身份证关联手机号个数
     * @param {*} b 手机号关联身份证个数
     */
    async getIdCardScore(a, b) {
        let aScore = 0;
        let bScore = 0;
        if (a >= 3) {
            aScore = parseInt(a * 3) > 20 ? 20 : parseInt(a * 3);
        } else if (a > 1) {
            aScore = 5;
        } else {
            aScore = 0;
        }
        if (b >= 3) {
            bScore = parseInt(b * 3) > 20 ? 20 : parseInt(b * 3);
        } else if (b > 1) {
            bScore = 5;
        } else {
            bScore = 0;
        }
        let score = (aScore + bScore) > 20 ? 20 : (aScore + bScore);
        return score;
    }


}

module.exports = BlacklistService;
