
'use strict';

const Service = require('egg').Service;
const moment = require('moment');
const _ = require('lodash');

class YysService extends Service {


    /**
     * 创建订单号
     * @param {*} 
     */
    async getOrderSn(phone) {
        const { ctx } = this;
        let params = {
            phone: phone
        }
        let url = this.config.NODE_BASE_URL + '/yys_api/getorderSn' + '?appKey=' + this.config.YYS_APP_KEY;
        let resp = await ctx.helper.send_request(url, params, { method: 'POST' });
        ctx.logger.info({ url: JSON.stringify(resp) });
        return resp.data;
    }

    /**
    * 获取验证码
    * @param {*} 
    */
    async getCode(params) {
        const { ctx } = this;
        let params = {
            orderSn: params.order_sn,
            data: {
                password: params.password
            }
        }
        let url = this.config.NODE_BASE_URL + '/yys_api/getCode' + '?appKey=' + this.config.YYS_APP_KEY;
        let resp = await ctx.helper.send_request(url, params, { method: 'POST' });
        ctx.logger.info({ url: JSON.stringify(resp) });
        return resp.data;
    }


    /**
    * 提交任务
    * @param {*} params 需要提交的参数,根据getOrderSn的operator来确定需要的参数
    */
    async commit(params) {

        const { ctx } = this;
        // let params = {
        //     orderSn: params.order_sn,
        //     params: {
        //         password: params.password
        //     }
        // }
        const url = this.config.NODE_BASE_URL + '/yys_api/commit' + '?appKey=' + this.config.YYS_APP_KEY;
        const resp = await ctx.helper.send_request(url, params, { method: 'POST' });
        ctx.logger.info({ url: JSON.stringify(resp) });
        return resp.data;
    }

    /**
    * 查询任务状态
    * @param {*} orderSn 创建订单时生成的订单号
    */
    async query(orderSn) {
        const { ctx } = this;
        let params = {
            orderSn: orderSn,
        }
        let url = this.config.NODE_BASE_URL + '/yys_api/query' + '?appKey=' + this.config.YYS_APP_KEY;
        let resp = await ctx.helper.send_request(url, params, { method: 'POST' });
        ctx.logger.info({ url: JSON.stringify(resp) });
        return resp.data;
    }

    /**
    * 获取报告
    * @param {*} orderSn 创建订单时生成的订单号
    */
    async getData(orderSn) {

        const { ctx } = this;

        //调用数据接口获取通话检测报告数据
        let params = {
            sign: "",
            signParams: {
                appKey: this.config.YYS_APP_KEY,
                timestamp: String(new Date().getTime()),
            },
            orderSn,
        }
        params.sign = await ctx.service.credit.common.sign(params.signParams, this.config.YYS_APPLY_APPSECRET);
        const url = this.config.YYS_APPLY_URL;
        const result = await ctx.helper.send_request(url, params, { method: 'POST' });
        ctx.logger.info(JSON.stringify({ thxdReport_parmas: params, thxdReport_result: result }));
        return result.data;

    }


}

module.exports = YysService;
