'use strict';

const Controller = require('egg').Controller;
const xml2js = require('xml2js').parseString;
class OrderController extends Controller {

    /**
     * 我的信用首页
     */
    async getMyCredit() {

        const { ctx } = this;


        ctx.success(ret);

    }

    //我的历史首页
    async getRecord() {

        const { ctx } = this;
        const type = ctx.params.type;

        const results = await ctx.service.credit.order.getHistoryOrders(type);

        ctx.success({ results });
    }

    //微信支付
    async payOrder() {

        const { ctx } = this;
        const order_id = ctx.params.order_id;
        const result = await ctx.service.credit.common.unifiedOrder('wexin', order_id);

        ctx.success({ result });
    }

    async payNotice() {

        const { ctx } = this;
        let data = '';
        ctx.req.setEncoding('utf8');
        ctx.req.on('data', function (chunk) {
            data += chunk;
        });
        const getxml = await new Promise(function (resolve) {
            ctx.req.on('end', function () {
                resolve(data);
            });
        });
        const ret_obj = await ctx.helper.xmlTojson(getxml);
        ctx.logger.info({ notice_params: ret_obj });
        const ret = await ctx.service.credit.common.WexinNotify(ret_obj);
        ctx.success({ ret_obj, ret });
        return;
        ctx.success("<xml><return_code>SUCCESS</return_code><return_msg>OK</return_msg></xml>");
    }

    async checkPay() {

        const { ctx } = this;
        const order_id = ctx.params.order_id;
        const is_pay = ctx.service.credit.order.checkOrderPay(order_id);
        let result = false;
        if (is_pay) {
            result = true;
        }

        ctx.success({ result });
    }


}

module.exports = OrderController;
