'use strict';

module.exports = appInfo => {
  const config = exports = {};
  config.debug = true;

  // use for cookie sign key, should change to your own and keep security
  config.keys = appInfo.name + '_1554705194320_9697';


  config.projectRootPath = '/51business/api';

  config.logger = {
    dir: '/jianbing/logs/51business',
  };
  // add your config here
  config.middleware = [ 'errorHandler', 'deviceLogin', 'deviceInit', 'responseSet' ];

  // 是否启用csrf安全
  config.security = {
    csrf: {
      enable: false,
    },
    domainWhiteList: [],
  };

  config.sequelize = {

    datasources: [
      {
        // 东八时区
        timezone: '+08:00',
        delegate: 'blockModel',
        baseDir: 'model/block',
        // other sequelize configurations
        dialect: 'mysql',
        host: process.env.MYSQL_BLOCK_HOST,
        database: process.env.MYSQL_BLOCK_DB_NAME,
        username: process.env.MYSQL_BLOCK_USER,
        password: process.env.MYSQL_BLOCK_PWD,
        port: 3306,
      },
      {
        // 公积金数据库
        timezone: '+08:00',
        delegate: 'gjjModel',
        baseDir: 'model/gjj',
        dialect: 'mysql',
        host: process.env.MYSQL_GJJ_HOST,
        database: process.env.MYSQL_GJJ_DB_NAME,
        username: process.env.MYSQL_GJJ_USER,
        password: process.env.MYSQL_GJJ_PWD,
        port: 3306,
      },
      {
        // 东八时区
        timezone: '+08:00',
        delegate: 'realestateModel',
        baseDir: 'model/realestate',
        // other sequelize configurations
        dialect: 'mysql',
        host: process.env.MYSQL_REALESTATE_HOST,
        database: process.env.MYSQL_REALESTATE_DB_NAME,
        username: process.env.MYSQL_REALESTATE_USER,
        password: process.env.MYSQL_REALESTATE_PWD,
        port: 3306,
      },
      {
        // 东八时区
        timezone: '+08:00',
        delegate: 'huodongModel',
        baseDir: 'model/huodong',
        // other sequelize configurations
        dialect: 'mysql',
        host: process.env.MYSQL_HUODONG_HOST,
        database: process.env.MYSQL_HUODONG_DB_NAME,
        username: process.env.MYSQL_HUODONG_USER,
        password: process.env.MYSQL_HUODONG_PWD,
        port: 3306,
      },
      {
        // 东八时区
        timezone: '+08:00',
        delegate: 'prometheusModel',
        baseDir: 'model/prometheus',
        // other sequelize configurations
        dialect: 'mysql',
        host: process.env.MYSQL_PROMETHEUS_HOST,
        database: process.env.MYSQL_PROMETHEUS_DB_NAME,
        username: process.env.MYSQL_PROMETHEUS_USER,
        password: process.env.MYSQL_PROMETHEUS_PWD,
        port: 3306,
      },
    ],

  };

  config.redis = {
    client: {
      port: 6379,
      host: process.env.REDIS_HOST,
      password: process.env.REDIS_PWD,
      db: 0,
    },
  };

  config.CDN_BASE_URL = 'https://r.51gjj.com/image/';
  config.NODE_URL = process.env.NODE_URL;
  config.NODE_BASE_URL = process.env.NODE_BASE_URL;
  config.PHP_URL = process.env.PHP_URL;

  config.HOUSE_SERVICE_API = process.env.HOUSE_SERVICE_API; // 房产

  config.USER_CENTER_API_URI = process.env.USER_CENTER_API_URI;


  return config;
};
