'use strict';

const Controller = require('egg').Controller;
const http = require('http');
const process = require('child_process');
const Spider = require('node-spider');
class ToolController extends Controller {

    //获取地图上的点位
    async getMapPoint() {
        const { ctx } = this;
        const input_parmas = ctx.params;
        const rule = {
            house_style: { type: 'string', required: true },
            area_code: { type: 'string', required: true },
            level: { type: 'string', required: true },
        }
        ctx.validate(rule, input_parmas);

        const house_style = input_parmas.house_style;
        const area_code = input_parmas.area_code;
        const level = input_parmas.level;

        let ret = [];
        if (house_style === 'used_house') {
            ret = await ctx.service.house.tool.getUsedHouseMapPoint(area_code, level);
        } else if (house_style === 'new_house') {
            ret = await ctx.service.house.tool.getNewHouseMapPoint(area_code, level);
        }

        ctx.success({ results: ret });
    }

    //生成购房计划
    async generateBuyHousePlan() {

        const { ctx } = this;
        const input_parmas = ctx.request.body;
        const rule = {
            city_code: { type: 'string', required: true },
            down_payment: { type: 'string', required: true },
            invest_payment: { type: 'string', required: true }
        }
        ctx.validate(rule, input_parmas);

        const target_house = await ctx.blockModel.HousePriceMap.one({ where: { id: input_parmas.city_code } });
        let target_price = 0;
        if (target_house && target_house.price) {
            target_price = target_house.price;
        }
        const filter = {
            price: { min: target_price - 300000, max: target_price + 300000 },
        }
        const recommend_houses = await ctx.service.house.rentalHouse.getRentalHousesByFilter(filter);//推荐房源
        // const recommend_houses = [];//推荐房源

        const house_plan = await ctx.service.house.tool.generateHousePlan(input_parmas);//计算购房能力 生成购房计划
        const ret = {
            house_plan,
            recommend_houses,
        }

        ctx.success({ results: ret });
    }

    //type类型；trend：房价指数；increase：房价涨跌 ;question: 购房问题
    async getHousePriceFeature() {

        const { ctx } = this;
        const input_parmas = ctx.params;
        const rule = {
            type: { type: 'string', required: true },
            area_code: { type: 'string', required: true },
        }
        ctx.validate(rule, input_parmas);

        const type = input_parmas.type;
        const area_code = input_parmas.area_code;
        let ret = [];
        if (type === 'trend') {
            ret = await ctx.blockModel.HousePriceTrend.one({ where: { id: area_code } });
            ret = ret.trend_json;
        } else if (type === 'increase') {
            ret = await ctx.blockModel.HouseQuestion.one({ where: { id: area_code } });
            ret = ret.increase_json;
        } else if (type === 'question') {
            ret = await ctx.blockModel.HouseQuestion.one({ where: { id: area_code } });
            ret = ret.question_json;
        }

        ctx.success(ret);
    }

    async calculateHousePrice2() {
        const { ctx } = this;
        
        var Spider = require('node-spider');
        const data = {
            userName: '',
            gardenId: '',
            gardenInternalID: 'c1283359-9995-4a52-ae76-ca06135b825c',
            name: '中天九溪诚品',
            area: 100,
            floor: 2,
            totlaFloor: 6,
            directionStr: 'SOUTHEAST',
            buildingId: '',
            building: '',
            roomNoId: '',
            roomNo: '',
            subQueryType: 'quick',
        }
        await this.httprequest('https://hangzhou.qfang.com/fangjia/chaxun?userName=&gardenId=&gardenInternalID=F3365A31BBB6F477E040A8C112002A44&name=%E5%9F%8E%E4%B8%AD%E8%8A%B1%E5%9B%AD&area=100&floor=1&totlaFloor=12&directionStr=NORTHSOUTH&buildingId=&building=&roomNoId=&roomNo=&subQueryType=quick', data);
        return;
        var spider = new Spider({
            // How many requests can be run in parallel
            concurrent: 5,
            // How long to wait after each request
            delay: 0,
            // A stream to where internal logs are sent, optional
            logs: process.stderr,
            // Re-visit visited URLs, false by default
            allowDuplicates: false,
            // If `true` all queued handlers will be try-catch'd, errors go to `error` callback
            catchErrors: true,
            // If `true` the spider will set the Referer header automatically on subsequent requests
            addReferrer: true,
            // If `true` adds the X-Requested-With:XMLHttpRequest header
            xhr: false,
            // If `true` adds the Connection:keep-alive header and forever option on request module
            keepAlive: false,
            // Called when there's an error, throw will be used if none is provided
            error: function (err, url) {

            },
            // Called when there are no more requests
            done: function () {

            },
            method: 'POST',
            body: data,
            headers: {
                'Host': 'hangzhou.qfang.com',
                'Connection': 'keep-alive',
                'Content-Length': '242',
                'Cache-Control': 'max-age=0',
                'Origin': 'https://hangzhou.qfang.com',
                'Upgrade-Insecure-Requests': 1,
                'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.98 Safari/537.36 LBBROWSER',
                'Content-Type': 'application/x-www-form-urlencoded',
                'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
                'Referer': 'https://hangzhou.qfang.com/fangjia/area',
                'Accept-Encoding': 'gzip, deflate, br',
                'Accept-Language': 'zh-CN,zh;q=0.8',
                'Cookie': 'acw_tc=0e1d391d15550609946915691ecd9bd6cfe0fae2fd1056fc4cc49c0a89; sid=72d0d94c-dd84-4fcb-a21c-29c0aa101544; cookieId=75f8366e-31ce-43db-bb64-a9f41df1ce4f; qchatid=92e2bc4e-a998-448a-8a5c-c54344a88c0c; language=SIMPLIFIED; JSESSIONID=aaaPSWGfw3iIxdW362qOw; looks=GARDEN%2C1758%2C1758%7CGARDEN%2C4552195%2C4552195; sec_tc=AQAAACYaNEoaMwgAeuCC4l0hf8QCTSkM; quickGardenHistory=%5B%7B%22name%22%3A%22%E4%B8%AD%E5%A4%A9%E4%B9%9D%E6%BA%AA%E8%AF%9A%E5%93%81%22%2C%22id%22%3A%22c1283359-9995-4a52-ae76-ca06135b825c%22%7D%2C%7B%22name%22%3A%22%E5%9F%8E%E4%B8%AD%E8%8A%B1%E5%9B%AD%22%2C%22id%22%3A%22F3365A31BBB6F477E040A8C112002A44%22%7D%5D; HOUSE_PRICE_TOKEN=c1ea3ec587eb45aea1bfd9838c65e279; _ga=GA1.3.1611092705.1555060995; _gid=GA1.3.1809773729.1555314385; WINDOW_DEVICE_PIXEL_RATIO=1; Hm_lvt_de678bd934b065f76f05705d4e7b662c=1555060996; Hm_lpvt_de678bd934b065f76f05705d4e7b662c=1555394042',
                // 'host': 'hangzhou.qfang.com',
                // 'connection': 'keep-alive',
                // 'content-length': '242',
                // 'cache-control': 'max-age=0',
                // 'origin': 'https://hangzhou.qfang.com',
                // 'upgrade-insecure-requests': 1,
                // 'user-agent': 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.98 Safari/537.36 LBBROWSER',
                // 'content-type': 'application/x-www-form-urlencoded',
                // 'accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
                // 'referer': 'https://hangzhou.qfang.com/fangjia/area',
                // 'accept-encoding': 'gzip, deflate, br',
                // 'accept-language': 'zh-CN,zh;q=0.8',
                // 'cookie': 'acw_tc=0e1d391d15550609946915691ecd9bd6cfe0fae2fd1056fc4cc49c0a89; sid=72d0d94c-dd84-4fcb-a21c-29c0aa101544; cookieId=75f8366e-31ce-43db-bb64-a9f41df1ce4f; qchatid=92e2bc4e-a998-448a-8a5c-c54344a88c0c; language=SIMPLIFIED; JSESSIONID=aaaPSWGfw3iIxdW362qOw; looks=GARDEN%2C1758%2C1758%7CGARDEN%2C4552195%2C4552195; sec_tc=AQAAACYaNEoaMwgAeuCC4l0hf8QCTSkM; quickGardenHistory=%5B%7B%22name%22%3A%22%E4%B8%AD%E5%A4%A9%E4%B9%9D%E6%BA%AA%E8%AF%9A%E5%93%81%22%2C%22id%22%3A%22c1283359-9995-4a52-ae76-ca06135b825c%22%7D%2C%7B%22name%22%3A%22%E5%9F%8E%E4%B8%AD%E8%8A%B1%E5%9B%AD%22%2C%22id%22%3A%22F3365A31BBB6F477E040A8C112002A44%22%7D%5D; HOUSE_PRICE_TOKEN=c1ea3ec587eb45aea1bfd9838c65e279; _ga=GA1.3.1611092705.1555060995; _gid=GA1.3.1809773729.1555314385; WINDOW_DEVICE_PIXEL_RATIO=1; Hm_lvt_de678bd934b065f76f05705d4e7b662c=1555060996; Hm_lpvt_de678bd934b065f76f05705d4e7b662c=1555394042',
            },
            encoding: 'utf8'
        });

        // var handleRequest = function (doc) {
        //     // new page crawled
        //     console.log(doc.res); // response object
        //     // console.log(doc.url); // page url
        //     // uses cheerio, check its docs for more info
        //     // doc.$('a').each(function (i, elem) {
        //     //     // do stuff with element
        //     //     var href = doc.$(elem).attr('href').split('#')[0];
        //     //     var url = doc.resolve(href);
        //     //     // crawl more
        //     //     spider.queue(url, handleRequest);
        //     // });
        // };

        // const data = {
        //     userName: '',
        //     gardenId: '',
        //     gardenInternalID: 'c1283359-9995-4a52-ae76-ca06135b825c',
        //     name: '中天九溪诚品',
        //     area: 100,
        //     floor: 2,
        //     totlaFloor: 6,
        //     directionStr: 'SOUTHEAST',
        //     buildingId: '',
        //     building: '',
        //     roomNoId: '',
        //     roomNo: '',
        //     subQueryType: 'quick',
        // }

        // const header = {
        //     'Host': 'hangzhou.qfang.com',
        //     'Connection': 'keep-alive',
        //     'Content-Length': '242',
        //     'Cache-Control': 'max-age=0',
        //     'Origin': 'https://hangzhou.qfang.com',
        //     'Upgrade-Insecure-Requests': 1,
        //     'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.98 Safari/537.36 LBBROWSER',
        //     'Content-Type': 'application/x-www-form-urlencoded',
        //     'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
        //     'Referer': 'https://hangzhou.qfang.com/fangjia/area',
        //     'Accept-Encoding': 'gzip, deflate, br',
        //     'Accept-Language': 'zh-CN,zh;q=0.8',
        //     'Cookie': 'acw_tc=0e1d391d15550609946915691ecd9bd6cfe0fae2fd1056fc4cc49c0a89; sid=72d0d94c-dd84-4fcb-a21c-29c0aa101544; cookieId=75f8366e-31ce-43db-bb64-a9f41df1ce4f; qchatid=92e2bc4e-a998-448a-8a5c-c54344a88c0c; language=SIMPLIFIED; JSESSIONID=aaaPSWGfw3iIxdW362qOw; looks=GARDEN%2C1758%2C1758%7CGARDEN%2C4552195%2C4552195; sec_tc=AQAAACYaNEoaMwgAeuCC4l0hf8QCTSkM; quickGardenHistory=%5B%7B%22name%22%3A%22%E4%B8%AD%E5%A4%A9%E4%B9%9D%E6%BA%AA%E8%AF%9A%E5%93%81%22%2C%22id%22%3A%22c1283359-9995-4a52-ae76-ca06135b825c%22%7D%2C%7B%22name%22%3A%22%E5%9F%8E%E4%B8%AD%E8%8A%B1%E5%9B%AD%22%2C%22id%22%3A%22F3365A31BBB6F477E040A8C112002A44%22%7D%5D; HOUSE_PRICE_TOKEN=c1ea3ec587eb45aea1bfd9838c65e279; _ga=GA1.3.1611092705.1555060995; _gid=GA1.3.1809773729.1555314385; WINDOW_DEVICE_PIXEL_RATIO=1; Hm_lvt_de678bd934b065f76f05705d4e7b662c=1555060996; Hm_lpvt_de678bd934b065f76f05705d4e7b662c=1555394042',
        //     // 'host': 'hangzhou.qfang.com',
        //     // 'connection': 'keep-alive',
        //     // 'content-length': '242',
        //     // 'cache-control': 'max-age=0',
        //     // 'origin': 'https://hangzhou.qfang.com',
        //     // 'upgrade-insecure-requests': 1,
        //     // 'user-agent': 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.98 Safari/537.36 LBBROWSER',
        //     // 'content-type': 'application/x-www-form-urlencoded',
        //     // 'accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
        //     // 'referer': 'https://hangzhou.qfang.com/fangjia/area',
        //     // 'accept-encoding': 'gzip, deflate, br',
        //     // 'accept-language': 'zh-CN,zh;q=0.8',
        //     // 'cookie': 'acw_tc=0e1d391d15550609946915691ecd9bd6cfe0fae2fd1056fc4cc49c0a89; sid=72d0d94c-dd84-4fcb-a21c-29c0aa101544; cookieId=75f8366e-31ce-43db-bb64-a9f41df1ce4f; qchatid=92e2bc4e-a998-448a-8a5c-c54344a88c0c; language=SIMPLIFIED; JSESSIONID=aaaPSWGfw3iIxdW362qOw; looks=GARDEN%2C1758%2C1758%7CGARDEN%2C4552195%2C4552195; sec_tc=AQAAACYaNEoaMwgAeuCC4l0hf8QCTSkM; quickGardenHistory=%5B%7B%22name%22%3A%22%E4%B8%AD%E5%A4%A9%E4%B9%9D%E6%BA%AA%E8%AF%9A%E5%93%81%22%2C%22id%22%3A%22c1283359-9995-4a52-ae76-ca06135b825c%22%7D%2C%7B%22name%22%3A%22%E5%9F%8E%E4%B8%AD%E8%8A%B1%E5%9B%AD%22%2C%22id%22%3A%22F3365A31BBB6F477E040A8C112002A44%22%7D%5D; HOUSE_PRICE_TOKEN=c1ea3ec587eb45aea1bfd9838c65e279; _ga=GA1.3.1611092705.1555060995; _gid=GA1.3.1809773729.1555314385; WINDOW_DEVICE_PIXEL_RATIO=1; Hm_lvt_de678bd934b065f76f05705d4e7b662c=1555060996; Hm_lpvt_de678bd934b065f76f05705d4e7b662c=1555394042',
        // }
        // let ret2 = await ctx.curl('https://hangzhou.qfang.com/fangjia/chaxun', { method: 'POST', data: data, headers: header });
        // console.log(ret2)
        // start crawling




        //spider.queue('https://hangzhou.qfang.com/fangjia/chaxun', handleRequest);
    }
    async httprequest(url,data){
        const { ctx } = this;
        let ret2 = await ctx.curl('https://hangzhou.qfang.com/fangjia/area', { method: 'POST', data: data});
        console.log(ret2.headers['set-cookie'])
        var cookies = ret2.headers['set-cookie'];
        var cookie = '';
        for(let item in cookies) {
            let cookie_items = cookies[item].split(';');
            cookie += cookie_items[0] + '; ';
        }
        //var cookie = ret2.headers['set-cookie'].join(";");
        // console.log(cookie);
        //return
        // var https = require('https');
        // var querystring = require('querystring');
        
        // // form data
        // var postData = querystring.stringify(data);
        
        // // request option
        // var options = {
        // host: 'hangzhou.qfang.com',
        // port: 443,
        // method: 'POST',
        // path: '/fangjia/chaxun',
        // headers: {
        //     'Content-Type': 'application/x-www-form-urlencoded',
        //     'Content-Length': postData.length,
        //     'accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8',
        //     'accept-encoding': 'gzip, deflate, br',
        //     'accept-language': 'zh-CN,zh;q=0.9,en;q=0.8',
        //     'cookie': 'acw_tc=755bc0cd15535143523154399e729103d77373973de8985880cd7a47bc;cookieId=67f995ee-e083-44fb-b182-db029e5437d6; qchatid=34e9f77d-e899-4b7e-a4fb-cbc51bf40e04; _ga=GA1.3.1512146760.1553514363; WINDOW_DEVICE_PIXEL_RATIO=1; sid=017b524d-b74b-4a3a-89db-c5c5e4eb261d; language=SIMPLIFIED; JSESSIONID=aaa50dKCR89Ip7UNxArOw; Hm_lvt_de678bd934b065f76f05705d4e7b662c=1553514365,1555070292; quickGardenHistory=%5B%7B%22name%22%3A%22%E5%9F%8E%E4%B8%AD%E8%8A%B1%E5%9B%AD%22%2C%22id%22%3A%22F3365A31BBB6F477E040A8C112002A44%22%7D%5D; historyKeywords_HANGZHOU_SALE=%E5%9F%8E%E4%B8%AD%E8%8A%B1%E5%9B%AD; ROOM_SALE=%2Fsale%3Fkeyword%3D%E5%9F%8E%E4%B8%AD%E8%8A%B1%E5%9B%AD%5E%20%E5%9F%8E%E4%B8%AD%E8%8A%B1%E5%9B%AD; _gid=GA1.3.862841217.1555398388; HOUSE_PRICE_TOKEN=ee850cf8ab844430bebbec7bd5e3bc7f; sec_tc=AQAAAJooC1zSAAMAeuCC4lb23vtydnhS; Hm_lpvt_de678bd934b065f76f05705d4e7b662c=1555403781',
        //     'upgrade-insecure-requests': 1,
        //     'user-agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36',
        // }
        // };
        
        // // request object
        // var req = https.request(options, function (res) {
        // var result = '';
        // res.on('data', function (chunk) {
        //     result += chunk;
        // });
        // res.on('end', function () {
        //     console.log(result);
        // });
        // res.on('error', function (err) {
        //     console.log(err);
        // })
        // });
        
        // // req error
        // req.on('error', function (err) {
        // console.log(err);
        // });
        
        // //send request witht the postData form
        // req.write(postData);
        // req.end();
        var request = require('request');
        //var j = request.jar()
        //var cookie_string = await this.get_cookie();
        // request({url: 'https://hangzhou.qfang.com/fangjia/area', jar: j}, function () {
        //     var cookie_string = j.getCookieString(url); // "key1=value1; key2=value2; ..."
        //     //var cookies = j.getCookies(url);
        //     //console.log(cookie_string)
        
        // })
        //console.log(cookie_string)
        //var jar = await this.setJar(request.jar());
        request({
            url: url,
            jar: request.jar(),
            headers: {
                'accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8',
                'accept-encoding': 'gzip, deflate, br',
                'accept-language': 'zh-CN,zh;q=0.9,en;q=0.8',
                'cache-control': 'max-age=0',
                'cookie': cookie,
                'referer': 'https://hangzhou.qfang.com/fangjia/chaxun?userName=&gardenId=&gardenInternalID=F3365A31BBB6F477E040A8C112002A44&name=%E5%9F%8E%E4%B8%AD%E8%8A%B1%E5%9B%AD&area=100&floor=1&totlaFloor=12&directionStr=NORTHSOUTH&buildingId=&building=&roomNoId=&roomNo=&subQueryType=quick',
                'upgrade-insecure-requests': 1,
                'user-agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36',
            }
            // method: 'POST',
            // //form: data,
            // //rejectUnauthorized : false,
            // json: true,
            // headers: {
            //     'accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8',
            //     'accept-encoding': 'gzip, deflate, br',
            //     'accept-language': 'zh-CN,zh;q=0.9,en;q=0.8',
            //     'cache-control': 'max-age=0',
            //     'content-type': 'application/x-www-form-urlencoded',
            //     'cookie': 'acw_tc=755bc0cd15535143523154399e729103d77373973de8985880cd7a47bc; cookieId=67f995ee-e083-44fb-b182-db029e5437d6; qchatid=34e9f77d-e899-4b7e-a4fb-cbc51bf40e04; _ga=GA1.3.1512146760.1553514363; WINDOW_DEVICE_PIXEL_RATIO=1; sid=017b524d-b74b-4a3a-89db-c5c5e4eb261d; language=SIMPLIFIED; JSESSIONID=aaa50dKCR89Ip7UNxArOw; Hm_lvt_de678bd934b065f76f05705d4e7b662c=1553514365,1555070292; quickGardenHistory=%5B%7B%22name%22%3A%22%E5%9F%8E%E4%B8%AD%E8%8A%B1%E5%9B%AD%22%2C%22id%22%3A%22F3365A31BBB6F477E040A8C112002A44%22%7D%5D; historyKeywords_HANGZHOU_SALE=%E5%9F%8E%E4%B8%AD%E8%8A%B1%E5%9B%AD; ROOM_SALE=%2Fsale%3Fkeyword%3D%E5%9F%8E%E4%B8%AD%E8%8A%B1%E5%9B%AD%5E%20%E5%9F%8E%E4%B8%AD%E8%8A%B1%E5%9B%AD; _gid=GA1.3.862841217.1555398388; sec_tc=AQAAABeqDDL1SAcAeuCC4kBI21MsrAca; HOUSE_PRICE_TOKEN=e9be264a6cf5495d96c7cb3efcfa1268; _dc_gtm_UA-47416713-1=1; Hm_lpvt_de678bd934b065f76f05705d4e7b662c=1555400841',
            //     'origin': 'https://hangzhou.qfang.com',
            //     'referer': 'https://hangzhou.qfang.com/fangjia/chaxun',
            //     'upgrade-insecure-requests': 1,
            //     'user-agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36 ' ,           
            // },
            // body: JSON.stringify(data),
        }, function(error, response, body) {
            //console.log(error)
            console.log(response)
            if (!error && response.statusCode == 200) {
                

                var resultStr = body.replace(/\ +/g, ""); //去掉空格
                resultStr = resultStr.replace(/[ ]/g, "");    //去掉空格
                resultStr = resultStr.replace(/[\r\n]/g, ""); //去掉回车换行
                resultStr = resultStr.replace(/[\n]/g, ""); //去掉换行
                resultStr = resultStr.replace(/[\r]/g, ""); //去掉回车

                //console.log(resultStr) // 请求成功的处理逻辑

            }
        });
    };
    
    
    async get_cookie() {
        var request = require('request');
        var j = request.jar()
        //var cookie_string = '';
        request({url: 'https://hangzhou.qfang.com/fangjia/area', jar: j}, function () {
            var cookie_string = j.getCookieString(url); // "key1=value1; key2=value2; ..."
            
        
        })

        //request.on('data', )
    }
    
    async getJar() {
        var request = require('request');
        var jar;
        if(jar)
            return jar;
        else {
            jar = request.jar();
            return jar;
        }
    }
    
    async setJar(jarParam) {
      jar = jarParam;
    }

    async calculateHousePrice() {

        const { ctx } = this;
        const input_params = ctx.request.body;
        const rule = {
            area: { type: 'string', required: true },
            direction_str: { type: 'string', required: true },
            floor: { type: 'string', required: true },
            total_floor: { type: 'string', required: true },
        };
        // ctx.validate(rule, input_params);
        // const qfang_url = 'https://hangzhou.qfang.com/fangjia/area';
        const qfang_url2 = 'https://hangzhou.qfang.com/fangjia/chaxun?gardenInternalID=c1283359-9995-4a52-ae76-ca06135b825c&name=中天九溪诚品&area=100&floor=2&totlaFloor=6&directionStr=SOUTHEAST&subQueryType=quick';
        // const qfang_url2 = 'https://hangzhou.qfang.com/fangjia/chaxun?gardenInternalID=c1283359-9995-4a52-ae76-ca06135b825c&name=中天九溪诚品&area=100&floor=2&totlaFloor=6&directionStr=SOUTHEAST&subQueryType=quick';
        // const qfang_url2 = 'https://hangzhou.qfang.com/fangjia/chaxun?gardenInternalID=c1283359-9995-4a52-ae76-ca06135b825c&name=%E4%B8%AD%E5%A4%A9%E4%B9%9D%E6%BA%AA%E8%AF%9A%E5%93%81&area=100&floor=2&totlaFloor=6&directionStr=SOUTHEAST&subQueryType=quick';
        const data = {
            // userName: '',
            // gardenId: '',
            gardenInternalID: 'c1283359-9995-4a52-ae76-ca06135b825c',
            name: '中天九溪诚品',
            area: input_params.area || 100,
            floor: input_params.floor || 2,
            totlaFloor: input_params.total_floor || 6,
            directionStr: input_params.direction_str || 'SOUTHEAST',
            // buildingId: '',
            // building: '',
            // roomNoId: '',
            // roomNo: '',
            subQueryType: 'quick',
        }
        //    await process.exec('curl -c cookie.txt -L -d "gardenInternalID=c1283359-9995-4a52-ae76-ca06135b825c&name=中天九溪诚品&area=100&floor=2&totlaFloor=6&directionStr=SOUTHEAST&subQueryType=quick" https://hangzhou.qfang.com/fangjia/chaxun', function (error, stdout, stderr) {
        //         console.info(error);
        //         console.info(stderr);
        //         if (error === null) {
        //         //    process.exec('curl -b cookie.txt -L -d "gardenInternalID=c1283359-9995-4a52-ae76-ca06135b825c&name=中天九溪诚品&area=100&floor=2&totlaFloor=6&directionStr=SOUTHEAST&subQueryType=quick" https://hangzhou.qfang.com/fangjia/chaxun >> test.html', function (error2, stdout2, stderr2) {
        //         //         console.info(11111);
        //         //     });
        //         }
        //     });
        //     await process.exec('curl -b cookie.txt -L -d "gardenInternalID=c1283359-9995-4a52-ae76-ca06135b825c&name=中天九溪诚品&area=100&floor=2&totlaFloor=6&directionStr=SOUTHEAST&subQueryType=quick" https://hangzhou.qfang.com/fangjia/chaxun >> test.html', function(error, stdout, stderr){
        //         console.info(111111);
        //     });
        //     console.info(22222);
        //     ctx.success(12);
        //     return;
        // const request = (url) => http.get(qfang_url, function (resp) {
        //     let chunks = [];
        //     let size = 0;
        //     console.info('11111111111111111111111111111');
        //     console.info(resp.headers);
        //     if(resp.statusCode == 301 || resp.statusCode == 302){
        //         const redirectUrl = resp.headers['location'];
        //         request(redirectUrl);
        //     } else {
        //         resp.on('data', function (chunk) {
        //             chunks.push(chunk);
        //             size += chunk.length;
        //         });

        //         resp.on('end', function () {
        //             let data = Buffer.concat(chunks, size);
        //             let html = data.toString();
        //             console.info(html);
        //         });
        //     }
        // });
        // request(qfang_url);
        // console.info(2222);
        // ctx.success(11);
        // return;

        let ret1 = await ctx.curl(qfang_url2, { method: 'POST', data: data });
        let ret2 = await ctx.curl(ret1.headers.location, { method: 'POST', data: data });

        // const headers = ret1.headers;
        // const cookies = fs.readFileSync('cookie.txt').toString();
        // let ret = await ctx.curl(qfang_url2, { method: 'POST', data: data, headers: { Cookie: cookies } });
        // const html = ret.data.toString('utf8');
        // ctx.success(html);
        // return;
        ctx.success({ ret2 });
    }

    async getQFangAreaList() {

        const { ctx } = this;
        const input_parmas = ctx.query;
        const rule = {
            keyword: { type: 'string', required: true },
        }
        ctx.validate(rule, input_parmas);

        const qfang_url = 'https://hangzhou.qfang.com/fangjia/getGarden';
        const keyword = encodeURIComponent(input_parmas.keyword);
        const result = await ctx.helper.send_request(qfang_url + '?keyword=' + keyword, {}, { dataType: 'json' });
        let ret = [];
        const headers = result.headers;
        if (result.status === 200 && result.data && result.data.items) {
            const area_items = result.data.items;
            for (let i in area_items) {
                const area_item = area_items[i];
            }
        }

        ctx.success({ headers, ret: result.data });
    }
}

module.exports = ToolController;
