'use strict';

const Controller = require('egg').Controller;
class CommonController extends Controller {
  async signature() {
    const { service, ctx } = this;
    const ret = await service.common.oss.get_business_signature();
    ctx.success(ret);
  }

  async uploadOss() {
    const { ctx, service } = this;
    const input_params = ctx.request.body;

    if (typeof (input_params.image) === 'undefined') {
      ctx.failed('image error');
    }
    if (typeof (input_params.height) === 'undefined') {
      ctx.failed('height error');
    }
    if (typeof (input_params.width) === 'undefined') {
      ctx.failed('width error');
    }

    const result = await service.common.oss.uploadOss(input_params);
    const ret = { ret: result };
    ctx.success(ret);
  }
}
module.exports = CommonController;
