
'use strict';

const Service = require('egg').Service;
const moment = require('moment');

class CallriskService extends Service {



    /**
     * 黑名单报告
     */
    async getReport() {

        const { ctx } = this;

        const ret = await this.formatReport();
        return ret;

    }

    async formatReport() {

        const call_overview_monthes = ['3月'];
        const ret = {
            basics: {
                msg: '我们将依据您授权的运营商通话认证',//解析文案
                data: {
                    mobile: '159****2898', //手机号
                    operator: '美国长城', //运营商
                    net_time: '10月10天', //入网时长 
                    call_result_assessment: '优质', //通话结果评估 
                    report_time: '2019-09-03', //报告生成时间 
                    report_No: '1312312312321312', //报告编号 
                }

            },
            call_overview: {//通话概览
                msg: '解读：您当前检测的手机号码入网时长',
                monthes: ['2月', '2月', '2月', '2月', '2月', '2月',],
                data: {
                    '2月': {
                        call_time_month: '233', //月通话时长统计
                        call_fee_month: '333', //月话费
                        call_active_count_month: '233', //月主叫次数
                        call_passive_count_month: '233', //月被叫次数
                        call_count_month: '466', //月总通话次数 
                    },
                    '3月': {
                        call_time_month: '332', //月通话时长统计
                        call_fee_month: '332', //月话费
                        call_active_count_month: '332', //月主叫次数
                        call_passive_count_month: '332', //月被叫次数
                        call_count_month: '664', //月总通话次数 
                    },
                    '2月': {
                        call_time_month: '233', //月通话时长统计
                        call_fee_month: '333', //月话费
                        call_active_count_month: '233', //月主叫次数
                        call_passive_count_month: '233', //月被叫次数
                        call_count_month: '466', //月总通话次数 
                    },
                    '3月': {
                        call_time_month: '332', //月通话时长统计
                        call_fee_month: '332', //月话费
                        call_active_count_month: '332', //月主叫次数
                        call_passive_count_month: '332', //月被叫次数
                        call_count_month: '664', //月总通话次数 
                    },
                    '2月': {
                        call_time_month: '233', //月通话时长统计
                        call_fee_month: '333', //月话费
                        call_active_count_month: '233', //月主叫次数
                        call_passive_count_month: '233', //月被叫次数
                        call_count_month: '466', //月总通话次数 
                    },
                    '3月': {
                        call_time_month: '332', //月通话时长统计
                        call_fee_month: '332', //月话费
                        call_active_count_month: '332', //月主叫次数
                        call_passive_count_month: '332', //月被叫次数
                        call_count_month: '664', //月总通话次数 
                    },
                }
            },
            call_type: {//通话类型分析
                msg: '解读：近6个月，金融类通话累计为【*次】',
                data: {
                    bank_call_count: '12', //银行通话次数 
                    bank_call_time: '34', //银行通话时长 
                    bank_number_count: '232', //银行通话号码个数 
                    loan_call_count: '433', //贷款通话次数 
                    loan_call_time: '232', //贷款通话时长 
                    loan_number_count: '2323', //贷款通话号码个数 
                    court_call_count: '123', //法院通话次数 
                    collection_call_count: '123', //催收通话次数 
                    laywer_call_count: '34', //律师通话次数 
                    macao_call_count: '3434', //澳门电话通话次数 
                    c110_call_count: '542', //110通话次数
                    c120_call_count: '123', //120/119通话次数
                }
            },
            call_active: {//通话活跃分析
                msg: '解读：您的夜间通话次数占【较高/较低】，【',
                data: {
                    routine_call_time: '132', //常规时间通话时长 
                    night_call_time: '323', //深夜时间通话时长 
                    routine_call_count: '343', //常规时间通话次数 
                    night_call_count: '343', //深夜时间通话次数 
                    time_interval: ['0-3', '3-6', '6-9', '9-12', '12-15', '15-18', '18-21', '21-24',],//时间间隔
                    time_interval_active: {
                        '0-3': {
                            call_count: '23', //通话次数 
                            call_time: '111', //通话时长 
                        },
                        '3-6': {
                            call_count: '23', //通话次数 
                            call_time: '111', //通话时长 
                        },
                        '6-9': {
                            call_count: '23', //通话次数 
                            call_time: '111', //通话时长 
                        },
                        '9-12': {
                            call_count: '23', //通话次数 
                            call_time: '111', //通话时长 
                        },
                        '12-15': {
                            call_count: '23', //通话次数 
                            call_time: '111', //通话时长 
                        },
                        '15-18': {
                            call_count: '23', //通话次数 
                            call_time: '111', //通话时长 
                        },
                        '18-21': {
                            call_count: '23', //通话次数 
                            call_time: '111', //通话时长 
                        },
                        '21-24': {
                            call_count: '23', //通话次数 
                            call_time: '111', //通话时长 
                        },
                    },
                    cities: ['杭州', '上海', '北京'],
                    city_active: [
                        {
                            city: '杭州', //具体城市 
                            ranking: '1', //通话次数排名 
                            call_count: '123', //通话次数 
                            call_time: '222', //通话时长 
                        },
                        {
                            city: '杭州2', //具体城市 
                            ranking: '2', //通话次数排名 
                            call_count: '123', //通话次数 
                            call_time: '222', //通话时长 
                        },
                        {
                            city: '杭州3', //具体城市 
                            ranking: '3', //通话次数排名 
                            call_count: '123', //通话次数 
                            call_time: '222', //通话时长 
                        },
                    ],
                }
            },
            call_behavior: {//通话行为分析
                msg: '解读：您的静默时长、静默次数以及周期，占整',
                data: {
                    silence_count_3day: '2323', //静默3天以上的次数
                    silence_time_3day: '423', //静默总时长
                    silence_time_rate_3day: '2342', //静默时长占比 
                    silence_cycle: [
                        {
                            silence_begin_time: '2019-09-03 18:53:49', //静默开始时间 
                            silence_end_time: '2019-09-03 18:53:52', //静默结束时间 
                        },
                        {
                            silence_begin_time: '2019-09-03 18:53:49', //静默开始时间 
                            silence_end_time: '2019-09-03 18:53:52', //静默结束时间 
                        },
                        {
                            silence_begin_time: '2019-09-03 18:53:49', //静默开始时间 
                            silence_end_time: '2019-09-03 18:53:52', //静默结束时间 
                        },
                    ],
                    call_each_other: {//互通电话统计
                        active_call_count: 122,//主叫电话数
                        passive_call_count: 233,//被叫电话数
                        each_call_count: 100,//互相叫电话数
                    },
                    call_rank: {
                        maximum_active_call_count: '2423',//最多主叫通话次数 
                        maximum_active_call_city: '浙江温州',//最多主叫通话城市
                        maximum_active_call_number: '23',//最多主叫通话次数对应号码 
                        maximum_passive_call_count: '321',//最多被叫通话次数 
                        maximum_passive_call_city: '浙江丽水',//最多被叫通话城市
                        maximum_passive_call_number: '123',//最多被叫通话次数对应号码 
                        maximum_call_time: '132',//最多通话时长 
                        maximum_call_time_city: '浙江杭州',//最多通话时长城市
                        maximum_call_time_number: '1231',//最多通话时长对应号码 
                    }
                }
            }
        }

        return ret;

    }





}

module.exports = CallriskService;