'use strict';

module.exports = app => {
  const router = app.router.namespace(app.config.projectRootPath + '/course/v5');
  const miniAuth = app.middleware.miniAuthV5();// 因为不跟现有的用户中心系统，所以使用单独的登录中间件

  router.post('third', '/verification_code', 'course.v5.user.sendVerificationCode');// 发送验证码
  router.post('third', '/login/phone', 'course.v5.user.loginByPhone');// 手机号登录
  router.post('third', '/login/wechat', 'course.v5.user.loginByWX');// 微信登录
  router.post('third', '/user/register_user', miniAuth, 'course.v5.user.registerUserInfo');// 授权后注册用户
  router.get('third', '/user/info', miniAuth, 'course.v5.user.getUserInfo');// 获取用户信息
};
