
'use strict';

const Service = require('egg').Service;
const moment = require('moment');
const _ = require('lodash');

class YysService extends Service {


    /**
     * 创建订单号
     * @param {*} 
     */
    async getOrderSn(phone) {
        const { ctx } = this;
        let params = {
            phone: phone
        }
        let url = this.config.NODE_BASE_URL + '/getorderSn' + '?appKey=' + this.config.YYS_APP_KEY;
        let resp = await ctx.helper.send_request(url, params, { method: 'POST' });
        ctx.logger.info({ url: JSON.stringify(resp) });
        return resp.data;
    }

    /**
    * 获取验证码
    * @param {*} 
    */
    async getCode(params) {
        const { ctx } = this;
        let params = {
            orderSn: params.order_sn,
            data: {
                password: params.password
            }
        }
        let url = this.config.NODE_BASE_URL + '/getCode' + '?appKey=' + this.config.YYS_APP_KEY;
        let resp = await ctx.helper.send_request(url, params, { method: 'POST' });
        ctx.logger.info({ url: JSON.stringify(resp) });
        return resp.data;
    }


    /**
    * 提交任务
    * @param {*} params 需要提交的参数,根据getOrderSn的operator来确定需要的参数
    */
    async commit(params) {
        const { ctx } = this;
        let params = {
            orderSn: params.order_sn,
            params: {
                password: params.password
            }
        }
        let url = this.config.NODE_BASE_URL + '/commit' + '?appKey=' + this.config.YYS_APP_KEY;
        let resp = await ctx.helper.send_request(url, params, { method: 'POST' });
        ctx.logger.info({ url: JSON.stringify(resp) });
        return resp.data;
    }

    /**
    * 查询任务状态
    * @param {*} orderSn 创建订单时生成的订单号
    */
    async query(orderSn) {
        const { ctx } = this;
        let params = {
            orderSn: orderSn,
        }
        let url = this.config.NODE_BASE_URL + '/query' + '?appKey=' + this.config.YYS_APP_KEY;
        let resp = await ctx.helper.send_request(url, params, { method: 'POST' });
        ctx.logger.info({ url: JSON.stringify(resp) });
        return resp.data;
    }


}

module.exports = YysService;
